/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import oracle.eclipse.tools.cloud.java.FileFacade;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFileSystem;
import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.java.internal.RestClientJCSCustomerScratch;
import oracle.eclipse.tools.common.util.DomUtil;
import org.apache.commons.io.IOUtils;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.util.MapFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JavaServiceFile
extends FileFacade {
    JavaServiceFile(JavaServiceFolder parent, String name, String modified, String type, long size) {
        super(parent, name, modified, type, size);
    }

    void update(Element metadata) {
        super.update(DomUtil.text((Node)DomUtil.element((Element)metadata, (String)"modifiedOn")), DomUtil.text((Node)DomUtil.element((Element)metadata, (String)"type")), Long.valueOf(DomUtil.text((Node)DomUtil.element((Element)metadata, (String)"size"))));
    }

    @Override
    public JavaServiceFileSystem root() {
        return (JavaServiceFileSystem)super.root();
    }

    @Override
    public InputStream content() {
        JavaServiceFileSystem fs = this.root();
        return new ByteArrayInputStream(fs.client().getContent(fs.url(), fs.tenant(), RestClientJCSCustomerScratch.encode(this.path()), this.type(), null));
    }

    public void write(File file) {
        Path path = this.path();
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + RestClientJCSCustomerScratch.encode(path));
            fs.client().uploadFile(uri, file, fs.tenant());
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing \"" + path.toPortableString() + "\"", e);
        }
    }

    @Override
    public void write(InputStream content) {
        Path path = this.path();
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + RestClientJCSCustomerScratch.encode(path));
            fs.client().uploadContent(uri, IOUtils.toByteArray((InputStream)content), fs.tenant());
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing \"" + path.toPortableString() + "\"", e);
        }
    }

    @Override
    protected void copyFile(FolderFacade destination, String name) {
        if (destination instanceof JavaServiceFolder) {
            try {
                Map params = MapFactory.start().add((Object)"source", (Object)("/" + this.path().toPortableString())).add((Object)"recursive", (Object)"false").result();
                JavaServiceFileSystem fs = this.root();
                URI uri = new URI(String.valueOf(fs.url()) + RestClientJCSCustomerScratch.encode(destination.path()) + "/" + RestClientJCSCustomerScratch.encode(name));
                fs.client().doPost(uri, fs.tenant(), params);
            }
            catch (Exception e) {
                throw new RuntimeException("Error copying file \"" + name + "\"", e);
            }
        } else {
            super.copyFile(destination, name);
        }
    }

    @Override
    protected final void renameResource(String newName) {
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + this.path() + "?dest=" + RestClientJCSCustomerScratch.encode(newName));
            fs.client().doPut(uri, fs.tenant(), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Error renaming file \"" + this.name() + "\". " + e.getMessage());
        }
    }

    @Override
    public void delete() {
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + RestClientJCSCustomerScratch.encode(this.path()));
            fs.client().doDelete(uri, fs.tenant());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.parent().members().fetch();
    }
}

