/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.io.IOException;
import java.io.InputStream;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.java.ConflictResolver;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class FileFacade
extends ResourceFacade {
    private String type;
    private long size;

    protected FileFacade(FolderFacade parent, String name, String modified, String type, long size) {
        super(parent, name, modified);
        this.type = type;
        this.size = size;
    }

    protected synchronized void update(String modified, String type, long size) {
        super.update(modified);
        this.type = type;
        this.size = size;
    }

    public final synchronized String type() {
        return this.type;
    }

    public final synchronized long size() {
        return this.size;
    }

    public abstract InputStream content();

    public abstract void write(InputStream var1);

    @Override
    public final FileFacade copy(FolderFacade destination, String name, ConflictResolver conflictResolver, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new RuntimeException("Copy operation is canceled");
        }
        if (destination == null) {
            throw new IllegalArgumentException();
        }
        if (conflictResolver == null) {
            conflictResolver = new ConflictResolver();
        }
        destination.members().fetch();
        String n = name == null ? this.name() : name;
        ResourceFacade existing = destination.member(n);
        if (monitor.isCanceled()) {
            throw new RuntimeException("Copy operation is canceled");
        }
        if (existing != null) {
            ConflictResolver.Resolution resolution = conflictResolver.resolve(destination.path().append(n));
            if (resolution == ConflictResolver.Resolution.SKIP || resolution == ConflictResolver.Resolution.ABORT) {
                return null;
            }
            if (resolution == ConflictResolver.Resolution.OVERWRITE) {
                existing.delete();
            } else {
                throw new IllegalStateException();
            }
        }
        this.copyFile(destination, n);
        destination.members().fetch();
        return (FileFacade)destination.member(n);
    }

    protected void copyFile(FolderFacade destination, String name) {
        FileFacade file = destination.file(name, true);
        if (file == null) {
            throw new RuntimeException("Error creating file '" + name + "'");
        }
        InputStream content = this.content();
        try {
            file.write(content);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                CloudPlugin.log(e);
            }
        }
    }
}

