/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.internal;

import java.io.File;
import oracle.eclipse.tools.cloud.IOracleWebLogicTargetDef;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.sapphire.services.ValidationService;

public final class OracleWebLogicTargetDefServices {

    public static final class LocationValidationService
    extends ValidationService {
        protected Status compute() {
            WebLogicServerVersion version;
            File f;
            Value value = (Value)this.context(Value.class);
            Path location = (Path)value.content();
            if (location != null && (f = location.toFile()).isDirectory() && f.exists() && ((version = WebLogicServerVersion.detect((File)f)) == null || WebLogicServerVersion.VERSION_10_3_6.compareTo((Enum)version) != 0)) {
                String msg = NLS.bind((String)Resources.invalidWebLogicLocation, (Object)location.toOSString());
                return Status.createErrorStatus((String)msg);
            }
            return Status.createOkStatus();
        }
    }

    public static final class NameDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            ((IOracleWebLogicTargetDef)this.context(IOracleWebLogicTargetDef.class)).getLocation().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    NameDefaultValueService.this.refresh();
                }
            });
        }

        protected DefaultValueServiceData compute() {
            WebLogicServerVersion version;
            Path location = (Path)((IOracleWebLogicTargetDef)this.context(IOracleWebLogicTargetDef.class)).getLocation().content();
            if (location != null && (version = WebLogicServerVersion.detect((File)location.toFile())) != null) {
                return new DefaultValueServiceData(version.getRuntimeType().getName());
            }
            return new DefaultValueServiceData(Resources.defaultTargetName);
        }
    }

    private static final class Resources
    extends NLS {
        public static String defaultTargetName;
        public static String invalidWebLogicLocation;

        static {
            Resources.initializeMessages((String)OracleWebLogicTargetDefServices.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

