/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.internal;

import java.io.File;
import java.util.List;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.sapphire.services.ValidationService;

public final class JavaServiceConnectionServices {
    @Text(value="Folder \"{0}\" does not contain Java Runtime Environment.")
    private static LocalizableText invalidJavaLocation;
    @Text(value="Oracle Cloud applications must be developed with Java 7. The selected version is \"{0}\".")
    private static LocalizableText invalidJavaVersion;

    static {
        LocalizableText.init(JavaServiceConnectionServices.class);
    }

    public static final class JavaRuntimeEnvironmentLocationDefaultValueService
    extends DefaultValueService {
        protected DefaultValueServiceData compute() {
            IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.cloud");
            String java6Path = pref.get("Java7Location", null);
            if (java6Path != null && new File(java6Path).exists()) {
                return new DefaultValueServiceData(java6Path);
            }
            List<IVMInstall> java16Vms = OracleCloudTools.getCloudJavaVms();
            if (java16Vms.size() > 0) {
                return new DefaultValueServiceData(java16Vms.get(0).getInstallLocation().getAbsolutePath());
            }
            return new DefaultValueServiceData("");
        }
    }

    public static final class JavaRuntimeEnvironmentValidationService
    extends ValidationService {
        protected Status compute() {
            File location;
            String path = ((Value)this.context(Value.class)).text();
            if (path != null && (location = new File(path)).exists() && location.isDirectory()) {
                String jdkVersion = OracleCloudTools.getJDKVersion(location);
                if (jdkVersion != null) {
                    Version version = new Version(jdkVersion);
                    long seg1 = version.segment(0);
                    long seg2 = version.segment(1);
                    if (seg1 != 1L || seg2 != 7L) {
                        return Status.createErrorStatus((String)invalidJavaVersion.format(new Object[]{version.toString()}));
                    }
                } else {
                    return Status.createErrorStatus((String)invalidJavaLocation.format(new Object[]{path}));
                }
            }
            return Status.createOkStatus();
        }
    }
}

