/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.internal;

import java.io.File;
import java.util.List;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.IGitConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;

public class OracleDeveoperCloudConfigServices {
    public static String getBranchName(Repository repo) {
        String branchName;
        try {
            String fullBranch = repo.getFullBranch();
            if (fullBranch == null) {
                throw new NoHeadException(JGitText.get().pullOnRepoWithoutHEADCurrentlyNotSupported);
            }
            if (!fullBranch.startsWith("refs/heads/")) {
                throw new DetachedHeadException();
            }
            branchName = fullBranch.substring("refs/heads/".length());
        }
        catch (Exception e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPullCommand, (Throwable)e);
        }
        return branchName;
    }

    public static String computeGitUrlString(CloudProject cloudProj) {
        if (cloudProj != null) {
            List<String> list = cloudProj.getRemoteGitUrls();
            if (list.size() == 1) {
                return list.get(0);
            }
            for (String s : list) {
                if (!s.endsWith("/" + cloudProj.getProject().getIdentifier().toLowerCase() + ".git")) continue;
                return s;
            }
        }
        return null;
    }

    public static final class GitBranchNameValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            ((IGitConfig)this.context(IGitConfig.class)).getLocalGitRepoPath().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    GitBranchNameValueService.this.refresh();
                }
            });
        }

        protected DefaultValueServiceData compute() {
            String name = "master";
            IGitConfig gitConfig = (IGitConfig)this.context(IGitConfig.class);
            String gitPath = (String)gitConfig.getLocalGitRepoPath().content();
            if (gitPath != null) {
                try {
                    File git = new File(gitPath, ".git");
                    if (git.exists()) {
                        FileRepository repo = new FileRepository(git);
                        name = OracleDeveoperCloudConfigServices.getBranchName((Repository)repo);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new DefaultValueServiceData(name);
        }
    }

    public static final class HudsonUrlDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    HudsonUrlDefaultValueService.this.refresh();
                }
            };
            IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)this.context(IPushProjectsToCloudOp.class);
            op.getConnectionName().attach((Listener)listener);
            op.getCloudProjectId().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)this.context(IPushProjectsToCloudOp.class);
            CloudProject cp = (CloudProject)op.getCloudProject().content();
            String name = null;
            if (cp != null) {
                DevServiceDesc devService = cp.getDevServiceDesc();
                String cloudProjId = (String)op.getCloudProjectId().content();
                if (cloudProjId != null) {
                    name = DevCloudCore.getHudsonUrl(devService, cloudProjId);
                }
            } else {
                String cloudProjName = (String)op.getCloudProjectId().content();
                ICloudProfile config = DevCloudCore.findConnection((String)op.getConnectionName().content());
                String dcsUrl = DevCloudCore.getDevServiceUrl(config, cloudProjName);
                name = String.valueOf(dcsUrl) + "s/" + cloudProjName + "/hudson/";
            }
            return new DefaultValueServiceData(name != null ? name : "");
        }
    }

    public static final class LocalGitRepoPathDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            ((IGitConfig)this.context(IGitConfig.class)).getRemoteUrl().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    LocalGitRepoPathDefaultValueService.this.refresh();
                }
            });
        }

        protected DefaultValueServiceData compute() {
            IGitConfig gitConfig = (IGitConfig)this.context(IGitConfig.class);
            String remoteUrl = (String)gitConfig.getRemoteUrl().content();
            if (remoteUrl == null) {
                return new DefaultValueServiceData("");
            }
            int n = remoteUrl.lastIndexOf(47);
            String name = remoteUrl.substring(n + 1);
            File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            File gitRoot = new File(workspaceRoot, name);
            name = gitRoot.getAbsolutePath();
            return new DefaultValueServiceData(name);
        }
    }

    public static final class MavenUrlDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    MavenUrlDefaultValueService.this.refresh();
                }
            };
            IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)this.context(IPushProjectsToCloudOp.class);
            op.getConnectionName().attach((Listener)listener);
            op.getCloudProjectId().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            String cloudProjName;
            IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)this.context(IPushProjectsToCloudOp.class);
            ICloudProfile config = DevCloudCore.findConnection((String)op.getConnectionName().content());
            String name = "";
            if (config != null && config.getDevCloudBaseUrl().content() != null && (cloudProjName = (String)op.getCloudProjectId().content()) != null) {
                cloudProjName = cloudProjName.toLowerCase();
                CloudProject cp = (CloudProject)op.getCloudProject().content();
                if (cp != null) {
                    DevServiceDesc devService = cp.getDevServiceDesc();
                    name = DevCloudCore.getMavenUrl(devService, cloudProjName);
                } else {
                    String dcsUrl = DevCloudCore.getDevServiceUrl(config, cloudProjName);
                    name = String.valueOf(dcsUrl) + "s/" + cloudProjName + "/maven/";
                }
            }
            return new DefaultValueServiceData(name);
        }
    }

    public static final class RemoteGitRepoUrlDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    RemoteGitRepoUrlDefaultValueService.this.refresh();
                }
            };
            IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)this.context(IPushProjectsToCloudOp.class);
            op.getConnectionName().attach((Listener)listener);
            op.getCloudProjectId().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            String name;
            IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)this.context(IPushProjectsToCloudOp.class);
            ICloudProfile config = DevCloudCore.findConnection((String)op.getConnectionName().content());
            String string = name = config != null ? OracleDeveoperCloudConfigServices.computeGitUrlString((CloudProject)op.getCloudProject().content()) : null;
            if (name == null) {
                new DefaultValueServiceData("");
            }
            return new DefaultValueServiceData(name);
        }
    }
}

