/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.internal;

import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.IHudsonConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.hudson.HudsonClient;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.util.MutableReference;

public class HudsonJobCreateOpMethods {
    public static Status execute(final IHudsonConfig hudsonCfg, final IProject project, ProgressMonitor monitor) {
        final MutableReference status = new MutableReference();
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                status.set((Object)HudsonJobCreateOpMethods.createHudsonJobForProjects(hudsonCfg, project, monitor));
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, ProgressMonitorBridge.create((ProgressMonitor)monitor));
        }
        catch (CoreException e) {
            return StatusBridge.create((IStatus)e.getStatus());
        }
        return (Status)status.get();
    }

    private static Status createHudsonJobForProjects(IHudsonConfig hudsonCfg, IProject rootProject, IProgressMonitor monitor) {
        monitor.beginTask("Create Hudson build job for projects:", 100);
        IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)hudsonCfg.parent().element();
        String cloudProj = (String)op.getCloudProjectId().content();
        try {
            try {
                String dcsBaseUrl = null;
                CloudProject cp = (CloudProject)op.getCloudProject().content();
                if (cp != null) {
                    dcsBaseUrl = cp.getDevServiceDesc().getDevServiceUrl();
                } else {
                    ICloudProfile config = DevCloudCore.findConnection((String)op.getConnectionName().content());
                    String cloudProjName = (String)op.getCloudProjectId().content();
                    String orgId = cloudProjName.indexOf(95) > 0 ? cloudProjName.substring(0, cloudProjName.indexOf(95)) : (String)config.getIdentityDomain().content();
                    dcsBaseUrl = (String)config.getDevCloudBaseUrl().content();
                    if (!dcsBaseUrl.endsWith("/")) {
                        dcsBaseUrl = String.valueOf(dcsBaseUrl) + "/";
                    }
                    dcsBaseUrl = String.valueOf(dcsBaseUrl) + orgId + "/";
                }
                ICloudProfile devCloudTarget = DevCloudCore.findConnection((String)op.getConnectionName().content());
                Set list = WtpProjectUtil.findReferencedProjects((IProject)rootProject);
                for (IProject project : list) {
                    if (project == rootProject) continue;
                    Set childModules = WtpProjectUtil.findReferencedProjects((IProject)project);
                    for (IProject childProj : childModules) {
                        HudsonClient.createJob(hudsonCfg, devCloudTarget, dcsBaseUrl, cloudProj, childProj, project, monitor);
                        monitor.worked(1);
                        HudsonClient.startBuild(hudsonCfg, devCloudTarget, cloudProj, childProj, monitor);
                    }
                    HudsonClient.createJob(hudsonCfg, devCloudTarget, dcsBaseUrl, cloudProj, project, rootProject, monitor);
                    monitor.worked(1);
                    HudsonClient.startBuild(hudsonCfg, devCloudTarget, cloudProj, project, monitor);
                }
                HudsonClient.createJob(hudsonCfg, devCloudTarget, dcsBaseUrl, cloudProj, rootProject, null, monitor);
                if (list.size() == 0) {
                    HudsonClient.startBuild(hudsonCfg, devCloudTarget, cloudProj, rootProject, monitor);
                }
            }
            catch (Exception e) {
                CloudPlugin.logError("Error creating Hudson build job", e);
                Status status = StatusBridge.create((IStatus)CloudPlugin.createErrorStatus("Error creating Hudson build job. See Error Log view for more details.", e));
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }
}

