/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.IGitConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.dev.internal.CommitHelper;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GitCommitUtil {
    private IndexDiff indexDiff;
    private Set<String> notIndexed;
    private Set<String> indexChanges;
    private Set<String> notTracked;
    private Set<String> files;
    private Repository repo;
    private IResource[] selectedResources;
    protected static final RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
    @Text(value="Are you sure you want to delete the Git repository and working directory under \"{0}\"?")
    private static LocalizableText deleteGitRepoWarning;
    @Text(value="There are uncommitted changes in the working directory. Are you sure you want to continue?")
    private static LocalizableText deleteGitRepoWithChangeWarning;
    private static final int timeout = 1800;

    static {
        LocalizableText.init(GitCommitUtil.class);
    }

    public static Repository getRepositoriesFor(IProject project) {
        RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
        if (repositoryMapping != null) {
            return repositoryMapping.getRepository();
        }
        return null;
    }

    public GitCommitUtil(Repository repo, IResource[] selectedResources, boolean preselectAll) {
        this.repo = repo;
        this.selectedResources = new IResource[selectedResources.length];
        System.arraycopy(selectedResources, 0, this.selectedResources, 0, selectedResources.length);
    }

    public boolean prepareCommit(IProgressMonitor monitor) {
        this.resetState();
        IProject[] projects = this.getProjectsOfRepositories();
        try {
            this.buildIndexHeadDiffList(projects, monitor);
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        CommitHelper commitHelper = new CommitHelper(this.repo);
        if (!commitHelper.canCommit()) {
            return false;
        }
        return !this.files.isEmpty();
    }

    public Set<String> getChanges() {
        return this.files;
    }

    public Set<String> getNotTracked() {
        return this.notTracked;
    }

    private IProject[] getProjectsOfRepositories() {
        IProject[] projects;
        HashSet<IProject> ret = new HashSet<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping != null && mapping.getRepository() == this.repo) {
                ret.add(project);
            }
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    private void resetState() {
        this.files = new LinkedHashSet<String>();
        this.notIndexed = new LinkedHashSet<String>();
        this.indexChanges = new LinkedHashSet<String>();
        this.notTracked = new LinkedHashSet<String>();
        this.indexDiff = null;
    }

    private void buildIndexHeadDiffList(IProject[] selectedProjects, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        EclipseGitProgressTransformer jgitMonitor = null;
        if (monitor != null) {
            monitor.beginTask("calculatingChanges", 1000);
            jgitMonitor = new EclipseGitProgressTransformer(monitor);
        }
        CountingVisitor counter = new CountingVisitor();
        IProject[] iProjectArray = selectedProjects;
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                p.accept((IResourceVisitor)counter);
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        this.indexDiff = new IndexDiff(this.repo, "HEAD", IteratorService.createInitialIterator((Repository)this.repo));
        this.indexDiff.diff((ProgressMonitor)jgitMonitor, counter.count, 0, NLS.bind((String)"Repository: {0}", (Object)this.repo.getDirectory().getPath()));
        this.includeList(this.indexDiff.getAdded(), this.indexChanges);
        this.includeList(this.indexDiff.getChanged(), this.indexChanges);
        this.includeList(this.indexDiff.getRemoved(), this.indexChanges);
        this.includeList(this.indexDiff.getMissing(), this.notIndexed);
        this.includeList(this.indexDiff.getModified(), this.notIndexed);
        this.includeList(this.indexDiff.getUntracked(), this.notTracked);
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.done();
        }
    }

    private void includeList(Set<String> added, Set<String> category) {
        for (String filename : added) {
            if (!this.files.contains(filename)) {
                this.files.add(filename);
            }
            category.add(filename);
        }
    }

    public static void cloneGitRepo(IPushProjectsToCloudOp pushToCloudOp, IProgressMonitor monitor) throws CoreException {
        String cloudProjectName = (String)pushToCloudOp.getCloudProjectId().content();
        String localGitPath = (String)pushToCloudOp.getGitConfig().getLocalGitRepoPath().content();
        if (localGitPath == null) {
            File root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            String cloudProjName = (String)pushToCloudOp.getCloudProjectId().content();
            File gitPath = new File(root, String.valueOf(cloudProjName) + ".git");
            gitPath.mkdirs();
            localGitPath = gitPath.getAbsolutePath();
        }
        ICloudProfile devCloudTarget = DevCloudCore.findConnection((String)pushToCloudOp.getConnectionName().content());
        IGitConfig gitConfig = pushToCloudOp.getGitConfig();
        GitCommitUtil.cloneGitRepo(devCloudTarget, localGitPath, cloudProjectName, (String)gitConfig.getRemoteUrl().content(), monitor);
    }

    public static void cloneGitRepo(ICloudProfile config, String localGitPath, String cloudProjectName, String remoteUrl, IProgressMonitor monitor) throws CoreException {
        File workdir = new File(localGitPath);
        File gitFolder = new File(localGitPath, ".git");
        boolean isGitRepo = RepositoryCache.FileKey.isGitRepository((File)gitFolder, (FS)FS.DETECTED);
        if (!isGitRepo) {
            try {
                Ref idHEAD = GitCommitUtil.getHeadReference(config, remoteUrl, monitor);
                ArrayList<Ref> refs = new ArrayList<Ref>();
                if (idHEAD != null) {
                    refs.add(idHEAD);
                    GitCommitUtil.cloneRemoteRepo(refs, idHEAD, config, workdir, remoteUrl, monitor);
                } else {
                    GitCommitUtil.initEmptyGitRepo(config, cloudProjectName, remoteUrl);
                    idHEAD = GitCommitUtil.getHeadReference(config, remoteUrl, monitor);
                    refs.add(idHEAD);
                    GitCommitUtil.cloneRemoteRepo(refs, idHEAD, config, workdir, remoteUrl, monitor);
                }
            }
            catch (InvocationTargetException ie) {
                String msg = "Error accessing remote GIT repository: " + ie.getTargetException().getMessage();
                throw new CoreException(CloudPlugin.createErrorStatus(msg, null));
            }
            catch (Exception e) {
                String msg = "Error accessing remote GIT repository";
                throw new CoreException(CloudPlugin.createErrorStatus(msg, e));
            }
        }
    }

    public static Ref getHeadReference(ICloudProfile devConfig, String url, IProgressMonitor monitor) throws CoreException, URISyntaxException, IOException, InvocationTargetException, InterruptedException {
        String userHome = System.getProperty("user.home");
        File c2cDir = new File(userHome, "c2c");
        c2cDir.mkdirs();
        ICloudProfile config = devConfig;
        URIish uri = new URIish(url);
        UserPasswordCredentials credentials = new UserPasswordCredentials((String)config.getUser().content(), (String)config.getPassword().content());
        FileRepository repo = new FileRepository(c2cDir);
        ListRemoteOperation listRemoteOp = new ListRemoteOperation((Repository)repo, uri, 1800);
        listRemoteOp.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        listRemoteOp.run(monitor);
        Ref idHEAD = listRemoteOp.getRemoteRef("HEAD");
        Ref head = null;
        boolean headIsMaster = false;
        for (Ref r : listRemoteOp.getRemoteRefs()) {
            String n = r.getName();
            if (!n.startsWith("refs/heads/") || idHEAD == null || headIsMaster || !r.getObjectId().equals((AnyObjectId)idHEAD.getObjectId())) continue;
            headIsMaster = "refs/heads/master".equals(r.getName());
            if (head != null && !headIsMaster) continue;
            head = r;
        }
        if (head != null) {
            return head;
        }
        return idHEAD;
    }

    public static void cloneRemoteRepo(List<Ref> selectedBranches, Ref initialBranch, ICloudProfile devConfig, File workdir, String url, IProgressMonitor monitor) throws CoreException, URISyntaxException, IOException, InvocationTargetException, InterruptedException {
        boolean allSelected;
        ICloudProfile config = devConfig;
        URIish uri = new URIish(url).setUser((String)config.getUser().content());
        UserPasswordCredentials credentials = new UserPasswordCredentials((String)config.getUser().content(), (String)config.getPassword().content());
        GitCommitUtil.storeCredentials(uri, credentials);
        boolean bl = allSelected = selectedBranches.size() == 0;
        if (selectedBranches.size() == 0) {
            return;
        }
        String refToCheckout = selectedBranches.get(0).getName();
        if (initialBranch == null) {
            for (Ref ref : selectedBranches) {
                if (!ref.getName().endsWith("/master")) continue;
                refToCheckout = ref.getName();
                break;
            }
        } else {
            refToCheckout = initialBranch.getName();
        }
        String remoteName = "origin";
        boolean isCloneSubmodules = false;
        CloneOperation cloneOp = new CloneOperation(uri, allSelected, selectedBranches, workdir, refToCheckout, remoteName, 1800);
        cloneOp.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        cloneOp.setCloneSubmodules(isCloneSubmodules);
        cloneOp.run(monitor);
        RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
        util.addConfiguredRepository(new File(workdir, ".git"));
    }

    private static void storeCredentials(URIish uri, UserPasswordCredentials credentials) {
        try {
            org.eclipse.egit.core.Activator.getDefault().getSecureStore().putCredentials(uri, credentials);
        }
        catch (StorageException e) {
            Activator.handleError((String)UIText.LoginService_storingCredentialsFailed, (Throwable)e, (boolean)true);
        }
        catch (IOException e) {
            Activator.handleError((String)UIText.LoginService_storingCredentialsFailed, (Throwable)e, (boolean)true);
        }
    }

    public static void initEmptyGitRepo(ICloudProfile devConfig, String cloudProjName, String url) throws URISyntaxException, IOException, GitAPIException {
        String userHome = System.getProperty("user.home");
        File c2cDir = new File(userHome, "c2c");
        c2cDir.mkdirs();
        ICloudProfile config = devConfig;
        UserPasswordCredentials credentials = new UserPasswordCredentials((String)config.getUser().content(), (String)config.getPassword().content());
        FileRepository repo = new FileRepository(c2cDir);
        Git git = new Git((Repository)repo);
        InitCommand init = Git.init();
        init.setDirectory(c2cDir);
        git = init.call();
        File readme = new File(c2cDir, "README.txt");
        if (!readme.exists()) {
            FileUtil.writeTextFile((File)readme, (String)"Generated by OEPE.");
        }
        AddCommand add = git.add();
        add.addFilepattern(readme.getName());
        add.call();
        CommitCommand comit = git.commit();
        comit.setMessage("initial commit").setCommitter((String)config.getUser().content(), (String)config.getUser().content());
        comit.call();
        StoredConfig sconfig = git.getRepository().getConfig();
        sconfig.setString("remote", "origin", "url", url);
        sconfig.save();
        PushCommand push = git.push();
        push.setRemote("origin").setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        Iterable results = push.call();
        for (PushResult ps : results) {
            System.out.println(ps.getMessages());
        }
    }

    public static void deleteProjects(final boolean delete, final List<IProject> projectsToDelete, IProgressMonitor monitor) {
        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                for (IProject prj : projectsToDelete) {
                    prj.delete(delete, false, actMonitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsr, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
        }
        catch (CoreException e1) {
            Activator.logError((String)e1.getMessage(), (Throwable)e1);
        }
    }

    public static boolean deactivateGitRepo(final RepositoryNode gitLocal, IJobChangeListener listener) {
        String msg2;
        final ArrayList<RepositoryNode> selectedNodes = new ArrayList<RepositoryNode>();
        selectedNodes.add(gitLocal);
        boolean deleteWorkingDir = false;
        boolean removeProjects = false;
        final List<IProject> projectsToDelete = GitCommitUtil.findProjectsToDelete(gitLocal);
        Repository repository = gitLocal.getRepository();
        String msg = deleteGitRepoWarning.format(new Object[]{repository.getDirectory().getParent()});
        if (!GitCommitUtil.promprConfirmationDialog(msg)) {
            return false;
        }
        GitCommitUtil gitUtil = new GitCommitUtil(repository, (IResource[])projectsToDelete.toArray(new IProject[projectsToDelete.size()]), false);
        if (gitUtil.prepareCommit(null) && !GitCommitUtil.promprConfirmationDialog(msg2 = deleteGitRepoWithChangeWarning.text())) {
            return false;
        }
        deleteWorkingDir = true;
        removeProjects = true;
        final boolean deleteWorkDir = deleteWorkingDir;
        final boolean removeProj = removeProjects;
        Job job = new Job("Remove Git Repository"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.setTaskName("Delete Repository");
                if (removeProj) {
                    GitCommitUtil.deleteProjects(true, projectsToDelete, monitor);
                }
                util.removeDir(gitLocal.getRepository().getDirectory());
                try {
                    GitCommitUtil.deleteRepositoryContent(selectedNodes, deleteWorkDir);
                }
                catch (IOException e) {
                    return Activator.createErrorStatus((String)e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.REPOSITORY_DELETE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        if (gitLocal instanceof CloudRepositoryNode) {
            ((CloudRepositoryNode)gitLocal).getGitRepoNode().reset();
        }
        job.schedule();
        return true;
    }

    private static void deleteRepositoryContent(List<RepositoryNode> selectedNodes, boolean deleteWorkDir) throws IOException {
        for (RepositoryNode node : selectedNodes) {
            boolean isWorkingDirEmpty;
            Object[] files;
            File workTree;
            Repository repo = node.getRepository();
            File file = workTree = deleteWorkDir && !repo.isBare() ? repo.getWorkTree() : null;
            if (workTree != null && (files = workTree.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    if (GitCommitUtil.isTracked(file2, repo)) {
                        FileUtils.delete((File)file2, (int)3);
                    }
                    ++n2;
                }
            }
            repo.close();
            if (!repo.isBare()) {
                GitCommitUtil.closeSubmoduleRepositories(repo);
            }
            FileUtils.delete((File)repo.getDirectory(), (int)7);
            if (workTree == null) continue;
            if (node.getParent() != null && node.getParent().getType() == RepositoryTreeNodeType.SUBMODULES) {
                FileUtils.delete((File)workTree, (int)7);
                node.getParent().getRepository().notifyIndexChanged();
            }
            boolean bl = isWorkingDirEmpty = (files = workTree.list()) != null && files.length == 0;
            if (!isWorkingDirEmpty) continue;
            FileUtils.delete((File)workTree, (int)6);
        }
    }

    /*
     * Exception decompiling
     */
    private static void closeSubmoduleRepositories(Repository repo) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isTracked(File file, Repository repo) throws IOException {
        ObjectId objectId = repo.resolve("HEAD");
        RevTree tree = objectId != null ? new RevWalk(repo).parseTree((AnyObjectId)objectId) : null;
        TreeWalk treeWalk = new TreeWalk(repo);
        treeWalk.setRecursive(true);
        if (tree != null) {
            treeWalk.addTree((AnyObjectId)tree);
        } else {
            treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
        }
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
        treeWalk.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(Repository.stripWorkDir((File)repo.getWorkTree(), (File)file))));
        return treeWalk.next();
    }

    public static List<IProject> findProjectsToDelete(RepositoryNode node) {
        ArrayList<IProject> projectsToDelete = new ArrayList<IProject>();
        if (node.getRepository().isBare()) {
            return projectsToDelete;
        }
        File workDir = node.getRepository().getWorkTree();
        Path wdPath = new Path(workDir.getAbsolutePath());
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            IPath location = prj.getLocation();
            if (location != null && wdPath.isPrefixOf(location)) {
                projectsToDelete.add(prj);
            }
            ++n2;
        }
        return projectsToDelete;
    }

    public static boolean promprConfirmationDialog(String message) {
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)message);
    }

    static class CountingVisitor
    implements IResourceVisitor {
        int count;

        CountingVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            ++this.count;
            return true;
        }
    }
}

