/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.IGitConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.dev.internal.GitCommitUtil;
import oracle.eclipse.tools.cloud.dev.internal.OracleDeveoperCloudConfigServices;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.common.util.StringInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentStateManager;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.ide.undo.MoveProjectOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class GitCommitOpMethods {
    public static Status execute(final IGitConfig gitCfg, final Set<IProject> projectsToPush, ProgressMonitor monitor) {
        final MutableReference status = new MutableReference();
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                status.set((Object)GitCommitOpMethods.commitAndPushProjects(gitCfg, projectsToPush, monitor));
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, ProgressMonitorBridge.create((ProgressMonitor)monitor));
        }
        catch (CoreException e) {
            return StatusBridge.create((IStatus)e.getStatus());
        }
        return (Status)status.get();
    }

    private static Status commitAndPushProjects(IGitConfig gitCfg, Set<IProject> projectsToPush, IProgressMonitor monitor) {
        monitor.beginTask("Commit projects to Git repository:", 100);
        try {
            try {
                IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)gitCfg.parent().element();
                GitCommitUtil.cloneGitRepo(op, monitor);
                HashSet<IProject> list = new HashSet<IProject>();
                for (IProject rootProject : projectsToPush) {
                    list.add(rootProject);
                    GitCommitOpMethods.addDependentProjects(rootProject, list);
                    for (IProject project : list) {
                        monitor.subTask("commit project " + project.getName());
                        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
                        if (mapping == null) {
                            GitCommitOpMethods.moveProjectToGitRepo(project, gitCfg, monitor);
                        }
                        monitor.worked(1);
                    }
                }
                GitCommitOpMethods.commitProject(list, gitCfg, monitor);
                GitCommitOpMethods.pushProject(list, gitCfg, monitor);
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                monitor.done();
                return status;
            }
            catch (Exception e) {
                CloudPlugin.logError("Error commit project source to Git repository.", e);
                Status status = StatusBridge.create((IStatus)CloudPlugin.createErrorStatus("Error commit project source to Git repository. See Error Log view for more details.", e));
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static void addDependentProjects(IProject rootProj, Set<IProject> list) {
        IVirtualReference[] refs;
        if (ComponentCore.createComponent((IProject)rootProj) == null) {
            return;
        }
        IVirtualComponent comp = ComponentCore.createComponent((IProject)rootProj);
        IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj;
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent vcomp = ref.getReferencedComponent();
            if (!(vcomp instanceof VirtualArchiveComponent) && !list.contains(proj = vcomp.getProject())) {
                list.add(proj);
                GitCommitOpMethods.addDependentProjects(proj, list);
            }
            ++n2;
        }
    }

    private static void moveProjectToGitRepo(IProject project, IGitConfig gitCfg, IProgressMonitor monitor) throws CoreException {
        IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)gitCfg.parent().element();
        String localGitPath = (String)op.getGitConfig().getLocalGitRepoPath().content();
        try {
            String label = "Moving project";
            File newProjLocation = new File(localGitPath, project.getName());
            if (newProjLocation.exists()) {
                throw new RuntimeException("Project already exists in Git repository.");
            }
            MoveProjectOperation moveProjOp = new MoveProjectOperation(project, newProjLocation.toURI(), label);
            moveProjOp.execute(monitor, null);
            File gitProjLocation = new File(localGitPath, ".git");
            ConnectProviderOperation connectOp = new ConnectProviderOperation(project, gitProjLocation);
            connectOp.execute(monitor);
            project.close(monitor);
            project.open(monitor);
        }
        catch (Exception exception) {
            String msg = "Error moving projects to Git repository. One of the selected projects might already exist in Git. Please rename your projects and try again.";
            IStatus status = CloudPlugin.createWarningStatus(msg, new Exception("Project " + project.getName() + " already exists in Git"));
            throw new CoreException(status);
        }
    }

    public static RemoteConfig getConfiguredRemote(Repository repository) {
        ArrayList allRemotes;
        String branch;
        try {
            branch = repository.getBranch();
        }
        catch (IOException e) {
            CloudPlugin.log(e);
            return null;
        }
        if (branch == null) {
            return null;
        }
        String remoteName = ObjectId.isId((String)branch) ? "origin" : repository.getConfig().getString("branch", branch, "remote");
        try {
            allRemotes = RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
        }
        catch (URISyntaxException uRISyntaxException) {
            allRemotes = new ArrayList();
        }
        RemoteConfig defaultConfig = null;
        RemoteConfig configuredConfig = null;
        for (RemoteConfig config : allRemotes) {
            if (config.getName().equals("origin")) {
                defaultConfig = config;
            }
            if (remoteName == null || !config.getName().equals(remoteName)) continue;
            configuredConfig = config;
        }
        RemoteConfig configToUse = configuredConfig != null ? configuredConfig : defaultConfig;
        return configToUse;
    }

    private static void pushProject(Set<IProject> projects, IGitConfig gitCfg, IProgressMonitor monitor) throws CoreException {
        RemoteConfig config;
        Repository repo = GitCommitUtil.getRepositoriesFor(projects.iterator().next());
        String branchName = OracleDeveoperCloudConfigServices.getBranchName(repo);
        StoredConfig repoConfig = repo.getConfig();
        String remote = repoConfig.getString("branch", branchName, "remote");
        ICloudProfile profile = GitCommitOpMethods.getDeveloperCloudServiceTarget(gitCfg);
        if (remote != null) {
            MergeResult.MergeStatus sts;
            PullResult ps;
            if (".".equals(remote)) {
                String msg = "Failed to push project to remote Git repository.\n";
                msg = String.valueOf(msg) + "The selected branch is not configured to track any remote branch.\n";
                msg = String.valueOf(msg) + "Please use the Git repository view to configure the tracking branch";
                IStatus status = CloudPlugin.createErrorStatus(msg, null);
                throw new CoreException(status);
            }
            monitor.subTask(", pull Git branch from remote repository");
            HashSet<Repository> repos = new HashSet<Repository>();
            repos.add(repo);
            PullOperation pullOp = new PullOperation(repos, 30);
            pullOp.execute(monitor);
            monitor.worked(1);
            Map results = pullOp.getResults();
            Object result = results.get(repo);
            if (result instanceof IStatus) {
                IStatus sts2 = (IStatus)result;
                if (!sts2.isOK()) {
                    throw new CoreException(sts2);
                }
            } else if (result instanceof PullResult && (ps = (PullResult)result).getMergeResult() != null && (sts = ps.getMergeResult().getMergeStatus()) != null && !sts.isSuccessful()) {
                String msg = "Merge conflict is detected while pulling remote Git repo. \nPlease manually resolve the conflict before running the wizard.";
                throw new CoreException(CloudPlugin.createErrorStatus(msg, null));
            }
        }
        if ((config = GitCommitOpMethods.getConfiguredRemote(repo)) == null) {
            throw new CoreException(CloudPlugin.createErrorStatus("Remote GIT repository not configured properly", null));
        }
        monitor.subTask("push changes to remote Git repository");
        PushOperation op = new PushOperation(repo, config.getName(), false, 30);
        op.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider((String)profile.getUser().content(), (String)profile.getPassword().content()));
        GitCommitOpMethods.startGitPush(op);
    }

    private static void startGitPush(final PushOperation op) throws CoreException {
        final IStatus[] status = new IStatus[]{null};
        Job job = new Job("Pushing GIT changes"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    op.run(monitor);
                    PushOperationResult result = op.getOperationResult();
                    StringBuffer messages = new StringBuffer();
                    for (URIish uri : result.getURIs()) {
                        String errorMessage = result.getErrorMessage(uri);
                        if (errorMessage == null || errorMessage.length() <= 0) continue;
                        if (messages.length() > 0) {
                            messages.append(System.getProperty("line.separator"));
                        }
                        messages.append(errorMessage);
                    }
                    if (!result.isSuccessfulConnectionForAnyURI()) {
                        IStatus sts;
                        String msg = "Error push changes to remote Git repository: " + messages.toString();
                        status[0] = sts = CloudPlugin.createErrorStatus(msg, null);
                        CloudPlugin.log(4, msg);
                    }
                }
                catch (InvocationTargetException e) {
                    return CloudPlugin.createErrorStatus("Error pushing to remote Git", e);
                }
                return org.eclipse.core.runtime.Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.PUSH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            throw new CoreException(CloudPlugin.createErrorStatus("GIT Push is interrupted", e));
        }
        if (status[0] != null) {
            throw new CoreException(status[0]);
        }
    }

    private static Repository commitProject(Set<IProject> projects, IGitConfig gitCfg, IProgressMonitor monitor) throws CoreException {
        ICloudProfile config = GitCommitOpMethods.getDeveloperCloudServiceTarget(gitCfg);
        if (config == null) {
            throw new RuntimeException("Error detecting Cloud project name for " + Arrays.toString(projects.toArray()));
        }
        if (projects.size() == 0) {
            return null;
        }
        Repository repo = GitCommitUtil.getRepositoriesFor(projects.iterator().next());
        if (repo == null) {
            throw new CoreException(CloudPlugin.createErrorStatus("Error commit project to Git repository", null));
        }
        monitor.subTask("Commit changes to local Git repository");
        for (IProject p : projects) {
            IFile gitIgnore = p.getFile(".gitignore");
            if (gitIgnore.exists()) continue;
            StringBuffer text = new StringBuffer();
            text.append("build/\n");
            text.append("target/\n");
            text.append(".metadata\n");
            gitIgnore.create((InputStream)new StringInputStream(text.toString()), true, (IProgressMonitor)new NullProgressMonitor());
        }
        GitCommitUtil commitUtil = new GitCommitUtil(repo, new IResource[0], true);
        boolean hasChanges = commitUtil.prepareCommit(monitor);
        Set<String> changedFiles = commitUtil.getChanges();
        Set<String> notTracked = commitUtil.getNotTracked();
        GitCommitOpMethods.filter(changedFiles, projects);
        GitCommitOpMethods.filter(notTracked, projects);
        try {
            String author;
            String email = (String)config.getUser().content();
            String name = email.indexOf(64) > 0 ? email.substring(0, email.indexOf(64)) : email;
            String committer = author = String.valueOf(name) + "<" + email + ">";
            String message = (String)gitCfg.getCommitMessage().content();
            CommitOperation op = new CommitOperation(repo, changedFiles, notTracked, author, committer, message);
            op.setAmending(!hasChanges);
            op.execute(monitor);
            CommitMessageComponentStateManager.deleteState((Repository)repo);
            RepositoryMapping mapping = RepositoryMapping.findRepositoryMapping((Repository)repo);
            if (mapping != null) {
                mapping.fireRepositoryChanged();
            }
        }
        catch (TeamException te) {
            Throwable ex = te.getStatus().getException();
            if (ex.getMessage().equals("No changes")) {
                return repo;
            }
            throw new CoreException(CloudPlugin.createErrorStatus("Error commit project to Git repository:\n" + te.getMessage(), (Exception)((Object)te)));
        }
        catch (Exception ge) {
            CloudPlugin.log(ge);
            throw new CoreException(CloudPlugin.createErrorStatus("Error commit project to Git repository:\n" + ge.getMessage(), ge));
        }
        return repo;
    }

    private static void filter(Collection<String> set, Set<IProject> projects) {
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            String resName = it.next();
            boolean found = false;
            for (IProject proj : projects) {
                String path = proj.getLocation().toFile().getName();
                if (!resName.startsWith(String.valueOf(path) + "/")) continue;
                found = true;
            }
            if (found) continue;
            it.remove();
        }
    }

    private static ICloudProfile getDeveloperCloudServiceTarget(IGitConfig gitCfg) {
        IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)gitCfg.parent().element();
        ICloudProfile devCloudTarget = DevCloudCore.findConnection((String)op.getConnectionName().content());
        return devCloudTarget;
    }
}

