/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import java.util.List;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.DevCloudProjects;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;

public class DevServiceDesc
extends ServiceDesc {
    ICloudProfile devProfile = null;
    DevCloudProjects devCloudProjects = new DevCloudProjects(this);
    boolean isInternal = false;
    private boolean isShowAllProject = false;

    public DevServiceDesc(CloudConnection connection, String name, String url, ICloudProfile devProfile) {
        super(connection, name, ServiceDesc.TYPE.DCS, url);
        this.devProfile = devProfile;
    }

    public ICloudProfile devCloudProfile() {
        return this.devProfile;
    }

    public DevCloudProjects cloudProjects() {
        return this.devCloudProjects;
    }

    public CloudProject project(String name) {
        for (CloudProject project : (List)this.devCloudProjects.content()) {
            if (!project.name().equals(name)) continue;
            return project;
        }
        return null;
    }

    @Override
    public boolean isActivated() {
        return this.isActivated;
    }

    public String getDevServiceUrl() {
        String baseUrl = (String)this.devProfile.getDevCloudBaseUrl().content();
        String string = baseUrl = baseUrl != null ? baseUrl : "http://developer.us.oracle.com/";
        if (!baseUrl.endsWith("/")) {
            baseUrl = String.valueOf(baseUrl) + '/';
        }
        String dcsServiceId = null;
        dcsServiceId = !this.isInternal() ? String.valueOf(this.getName().toLowerCase()) + "-" + (String)this.devProfile.getIdentityDomain().content() : (String)this.devProfile.getIdentityDomain().content();
        String devCloudServiceUrl = String.valueOf(baseUrl) + dcsServiceId;
        return devCloudServiceUrl;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean val) {
        this.isInternal = val;
    }

    public boolean getShowAllProjects() {
        return this.isShowAllProject;
    }

    public void setShowAllProjects(boolean val) {
        this.isShowAllProject = val;
    }
}

