/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import org.eclipse.sapphire.util.ListFactory;

public final class DevCloudProjects
extends RemoteData<List<CloudProject>> {
    private DevServiceDesc devSvcDesc;

    DevCloudProjects(DevServiceDesc devCloudConn) {
        super("services", new Serializer());
        this.devSvcDesc = devCloudConn;
    }

    public DevServiceDesc devServiceDesc() {
        return this.devSvcDesc;
    }

    public CloudConnection connection() {
        return this.devSvcDesc.connection();
    }

    @Override
    protected List<CloudProject> read() throws Exception {
        ListFactory cloudProjList = ListFactory.start();
        List<CloudProject> ret = DevCloudCore.getCloudProjects(this.devSvcDesc, this.devSvcDesc.getShowAllProjects());
        if (ret == null) {
            return ListFactory.empty();
        }
        for (CloudProject cp : ret) {
            cp.setDevServiceDesc(this.devSvcDesc);
            cloudProjList.add((Object)cp);
        }
        return cloudProjList.result();
    }

    public List<CloudProject> restore(Map<String, Boolean> activationStates) throws Exception {
        Object list = this.read();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CloudProject cp = (CloudProject)iterator.next();
            String id = cp.getProject().getIdentifier();
            if (!activationStates.containsKey(id)) continue;
            Boolean isActivated = activationStates.get(id);
            cp.setActivated(isActivated);
        }
        return list;
    }

    private static final class Serializer
    extends RemoteData.Serializer<List<CloudProject>> {
        private Serializer() {
        }

        @Override
        public String id() {
            return ((DevCloudProjects)this.context()).label();
        }

        @Override
        public List<CloudProject> read(InputStream stream) throws Exception {
            DevCloudProjects context = (DevCloudProjects)this.context();
            ObjectInputStream st = new ObjectInputStream(stream);
            int size = st.readInt();
            HashMap<String, Boolean> activationStates = new HashMap<String, Boolean>();
            int i = 0;
            while (i < size) {
                String id = st.readUTF();
                Boolean val = st.readBoolean();
                activationStates.put(id, val);
                ++i;
            }
            return context.restore(activationStates);
        }

        @Override
        public void write(List<CloudProject> data, OutputStream stream) throws Exception {
            ObjectOutputStream st = new ObjectOutputStream(stream);
            st.writeInt(data.size());
            for (CloudProject service : data) {
                if (!(service instanceof CloudProject)) continue;
                CloudProject cps = service;
                st.writeUTF(cps.getProject().getIdentifier());
                st.writeBoolean(cps.isActivated());
            }
            st.flush();
        }
    }
}

