/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import java.io.IOException;
import java.util.List;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.dev.BuildService;
import oracle.eclipse.tools.cloud.dev.DcsBuildPlan;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.sapphire.util.ListFactory;

public class BuildPlans
extends RemoteData<List<Object>> {
    BuildService buildSvc = null;
    IBuildServer server = null;
    Object fetchingLock = new Object();

    public BuildPlans(BuildService buildSvc) {
        super(buildSvc.getProjectService().getServiceType().toString());
        this.buildSvc = buildSvc;
    }

    public BuildService getBuildService() {
        return this.buildSvc;
    }

    public void setBuildServer(IBuildServer s) {
        this.server = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Object> read() throws Exception {
        Object object = this.fetchingLock;
        synchronized (object) {
            if (this.server == null) {
                this.server = this.getBuidlServer(this.buildSvc);
            }
            try {
                ListFactory factory = ListFactory.start();
                IBuildModel model = BuildsUi.getModel();
                List plans = ((BuildModel)model).getPlans(this.server);
                if (plans.size() == 0) {
                    DevCloudCore.refreshBuildPlans((BuildServer)this.server, (IProgressMonitor)new NullProgressMonitor());
                }
                plans = ((BuildModel)model).getPlans(this.server);
                for (IBuildPlan plan : plans) {
                    if (!plan.isSelected()) continue;
                    DcsBuildPlan dcsPlan = new DcsBuildPlan(this.buildSvc, plan);
                    factory.add((Object)dcsPlan);
                }
                return factory.result();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ListFactory.empty();
    }

    private IBuildServer getBuidlServer(BuildService ps) throws OperationCanceledException, CoreException, IOException {
        IBuildServer server = DevCloudCore.findBuildServer(ps);
        if (server == null) {
            server = DevCloudCore.createBuildServer(ps);
        }
        return server;
    }
}

