/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.util.Set;
import oracle.eclipse.tools.cloud.RemoteData;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.services.PossibleValuesService;

public abstract class RemoteDataPossibleValuesService<T>
extends PossibleValuesService {
    @Text(value="Fetching...")
    private static LocalizableText fetching;
    @Text(value="Fetch Failed")
    private static LocalizableText fetchFailed;
    private final Listener listener = new Listener(){

        public void handle(Event event) {
            if (event instanceof RemoteData.ContentEvent || event instanceof RemoteData.FetchFailedEvent) {
                RemoteDataPossibleValuesService.this.broadcast();
            }
        }
    };
    private RemoteData<T> previous;

    static {
        LocalizableText.init(RemoteDataPossibleValuesService.class);
    }

    protected abstract RemoteData<T> remote();

    protected final void fillPossibleValues(Set<String> values) {
        RemoteData<T> rd = this.remote();
        if (rd != this.previous) {
            if (this.previous != null) {
                this.previous.detach(this.listener);
            }
            if (rd != null) {
                rd.attach(this.listener);
            }
            this.previous = rd;
        }
        if (rd != null) {
            if (rd.available()) {
                this.fillPossibleValues(rd, values);
            } else if (rd.fetchFailed()) {
                values.add(fetchFailed.text());
            } else {
                values.add(fetching.text());
                rd.fetch(true);
            }
        }
    }

    protected abstract void fillPossibleValues(RemoteData<T> var1, Set<String> var2);

    public void dispose() {
        super.dispose();
        if (this.previous != null) {
            this.previous.detach(this.listener);
            this.previous = null;
        }
    }
}

