/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.CloudProfileUtils;
import oracle.eclipse.tools.cloud.DataCenter;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.internal.DataCenters;
import oracle.eclipse.tools.cloud.profile.ICloudConnections;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public final class OracleCloudTools {
    public static final String ACCOUNT_SETUP_URL = "https://cloud.oracle.com";
    public static final String SDK_DOWNLOAD_URL = "https://cloud.oracle.com";
    public static final IRuntimeType RUNTIME_TYPE = ServerCore.findRuntimeType((String)"oracle.cloud");
    public static final IServerType SERVER_TYPE = ServerCore.findServerType((String)"oracle.cloud.server");
    public static final String SYS_PROP_BASE = "Oracle.Cloud";
    public static final String SYS_PROP_SDK = "Oracle.Cloud.SDK";
    public static final String SYS_PROP_DEBUG = "Oracle.Cloud.Debug";
    public static final String SYS_PROP_DEVCLOUD_DEBUG = "Oracle.Cloud.Dcs.Debug";
    public static final String SYS_PROP_JCS_INSTANCE_NAME = "Oracle.Cloud.JavaInstanceName";
    public static final String PREFERENCE_LOCAL_TARGET_OPTION = "LocalTargetOption";
    public static final String PREFERENCE_JAVA7_LOCATION = "Java7Location";
    public static final String PREFERENCE_DEV_CLOUD_CONNECTION = "DevCloudConnection";
    public static final String PREFERENCE_DEV_CLOUD_PROJECT = "DevCloudProject";
    public static final String PREFERENCE_DEV_CLOUD_GROUP_ID = "DevCloudGroupId";
    public static final String PREFERENCE_DEV_CLOUD_GENERATE_MAVEN_BUILD_FILE = "GenerateMavenBuildFile";
    public static final String PREFERENCE_DEV_CLOUD_CREATE_HUDSON_JOB = "CreateHudsonJob";
    private static final String[] SDK_MARKER_FILES = new String[]{"/lib/oracle.cloud.paas.api.jar", "/lib/whitelist.jar", "/lib/javacloud.jar"};
    private static final String CLOUD_CONNECTIONS_XML = "oracle-cloud-connections.xml";
    private static ICloudConnections profiles;
    private static List<CloudConnection> connections;
    private static RemoteData<Set<DataCenter>> datacenters;

    public static synchronized List<CloudConnection> connections() {
        if (connections == null) {
            ListFactory connectionsListFactory = ListFactory.start();
            File profilesPersistenceFile = new File(CloudPlugin.state().toFile(), CLOUD_CONNECTIONS_XML);
            try {
                profiles = (ICloudConnections)ICloudConnections.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(profilesPersistenceFile)));
            }
            catch (ResourceStoreException e) {
                CloudPlugin.log((Exception)((Object)e));
            }
            if (profiles != null) {
                for (ICloudProfile profile : profiles.getConnections()) {
                    profile.setPassword(CloudProfileUtils.getSecurePassword(profile));
                    connectionsListFactory.add((Object)new CloudConnection(profile));
                }
            }
            connections = connectionsListFactory.result();
        }
        return connections;
    }

    public static CloudConnection connection(String id) {
        for (CloudConnection connection : OracleCloudTools.connections()) {
            String pid = (String)connection.profile().getId().content();
            if (pid == null || !pid.equals(id)) continue;
            return connection;
        }
        return null;
    }

    public static CloudConnection connection(IServer server) {
        IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            return null;
        }
        OracleCloudRuntime rt = (OracleCloudRuntime)((Object)runtime.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
        if (rt == null) {
            return null;
        }
        return OracleCloudTools.connection((String)rt.getConfig().getProfileId().content());
    }

    public static synchronized CloudConnection connect() {
        OracleCloudTools.connections();
        ICloudProfile profile = (ICloudProfile)profiles.getConnections().insert();
        CloudConnection connection = new CloudConnection(profile);
        connections = ListFactory.start().add(connections).add((Object)connection).result();
        return connection;
    }

    static synchronized void remove(CloudConnection connection) {
        ListFactory connectionsListFactory = ListFactory.start();
        for (CloudConnection cn : OracleCloudTools.connections()) {
            if (cn == connection) continue;
            connectionsListFactory.add((Object)cn);
        }
        connections = connectionsListFactory.result();
    }

    public static File getDefaultSdk() {
        File location = null;
        String sysprop = System.getProperty(SYS_PROP_SDK);
        if (sysprop != null && OracleCloudTools.isValidSdk(location = new File(sysprop)) != Status.OK_STATUS) {
            location = null;
        }
        return location;
    }

    public static IStatus isValidSdk(File location) {
        if (location.exists() && location.isDirectory()) {
            String[] stringArray = SDK_MARKER_FILES;
            int n = SDK_MARKER_FILES.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (!new File(String.valueOf(location.getAbsolutePath()) + file).exists()) {
                    return CloudPlugin.createErrorStatus("Missing file " + file, null);
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    private static IVMInstall findVMInstall(IVMInstallType type, File vmInstallLocation) {
        IVMInstall[] iVMInstallArray = type.getVMInstalls();
        int n = iVMInstallArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall x = iVMInstallArray[n2];
            if (x.getInstallLocation().equals(vmInstallLocation)) {
                return x;
            }
            ++n2;
        }
        return null;
    }

    public static String getJDKVersion(File vmInstallLocation) {
        File javaExe = StandardVMType.findJavaExecutable((File)vmInstallLocation);
        if (javaExe == null) {
            return null;
        }
        IVMInstallType type = JavaRuntime.getDefaultVMInstall().getVMInstallType();
        if (type != null) {
            String vmId = "StandardVM " + System.currentTimeMillis();
            IVMInstall vm = OracleCloudTools.findVMInstall(type, vmInstallLocation);
            IVMInstall2 svm = null;
            if (vm == null) {
                VMStandin vmWorkingCopy = new VMStandin(type, vmId);
                vmWorkingCopy.setName(vmId);
                vmWorkingCopy.setInstallLocation(vmInstallLocation);
                vm = vmWorkingCopy.convertToRealVM();
                if (vm instanceof IVMInstall2) {
                    svm = (IVMInstall2)vm;
                }
            } else if (vm instanceof IVMInstall2) {
                svm = (IVMInstall2)vm;
            }
            if (svm != null) {
                String version = svm.getJavaVersion();
                if (vm.getId().equals(vmId)) {
                    type.disposeVMInstall(vmId);
                }
                return version;
            }
            if (vm.getId().equals(vmId)) {
                type.disposeVMInstall(vmId);
            }
        }
        return null;
    }

    public static List<IVMInstall> getCloudJavaVms() {
        ArrayList<IVMInstall> jcsVms = new ArrayList<IVMInstall>();
        IVMInstallType type = JavaRuntime.getDefaultVMInstall().getVMInstallType();
        if (type != null) {
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n = iVMInstallArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall x = iVMInstallArray[n2];
                File location = x.getInstallLocation();
                if (x.getName().startsWith("Oracle Cloud")) {
                    jcsVms.clear();
                    jcsVms.add(x);
                    break;
                }
                String jdkVersion = OracleCloudTools.getJDKVersion(location);
                if (jdkVersion != null) {
                    Version version = new Version(jdkVersion);
                    long seg1 = version.segment(0);
                    long seg2 = version.segment(1);
                    if (seg1 == 1L && seg2 == 7L) {
                        jcsVms.add(x);
                    }
                }
                ++n2;
            }
        }
        return jcsVms;
    }

    public static boolean isDevCloudDebugMode() {
        boolean result = false;
        String sysprop = System.getProperty(SYS_PROP_DEVCLOUD_DEBUG);
        if (sysprop != null) {
            result = Boolean.parseBoolean(sysprop);
        }
        return result;
    }

    public static boolean isDebugMode() {
        boolean result = false;
        String sysprop = System.getProperty(SYS_PROP_DEBUG);
        if (sysprop != null) {
            result = Boolean.parseBoolean(sysprop);
        }
        return result;
    }

    public static boolean hasCloudTarget(IFacetedProject fproj) {
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime : fproj.getTargetedRuntimes()) {
            IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
            if (r == null || r.getRuntimeType() != RUNTIME_TYPE) continue;
            return true;
        }
        return false;
    }

    public static synchronized RemoteData<Set<DataCenter>> getDataCenters() {
        if (datacenters == null) {
            datacenters = new DataCenters();
        }
        return datacenters;
    }

    public static String getSHA1CheckSum(File datafile) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            FileInputStream fis = new FileInputStream(datafile);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            fis.close();
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer("");
            int i = 0;
            while (i < mdbytes.length) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Authenticator overrideDefaultAuthenticator(final String adminUrl, final String userName, final String password) {
        Authenticator theAuthenticator = null;
        try {
            Class<?> cacheContainer = CloudPlugin.class.getClassLoader().loadClass("java.net.Authenticator");
            Field cacheField = cacheContainer.getDeclaredField("theAuthenticator");
            cacheField.setAccessible(true);
            theAuthenticator = (Authenticator)cacheField.get(null);
            cacheField.setAccessible(false);
            final boolean[] retry = new boolean[1];
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    URL url = this.getRequestingURL();
                    String urlStr = url.toString();
                    if (urlStr.startsWith(adminUrl)) {
                        if (retry[0]) {
                            return null;
                        }
                        PasswordAuthentication ret = new PasswordAuthentication(userName, password.toCharArray());
                        retry[0] = true;
                        return ret;
                    }
                    return super.getPasswordAuthentication();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return theAuthenticator;
    }

    public static String getIdmUrl(String baseAdminUrl, String dc) {
        String dbUrl = "https://idmconsole." + dc + "." + baseAdminUrl + "/identity/faces/pages/Identity.jspx";
        return dbUrl;
    }

    public static String getEmUrl(String baseAdminUrl, String dc, String serviceName) {
        String emUrl = "https://console." + dc + "." + baseAdminUrl + "/em/faces/javaservice?serviceName=" + serviceName + "&identityGroup=" + serviceName;
        return emUrl;
    }

    public static final String findUniqueServerName(String base) {
        int i = 0;
        String name = base;
        while (ServerCore.findServer((String)name) != null) {
            name = String.valueOf(base) + " (" + ++i + ")";
        }
        return name;
    }

    public static final String findUniqueRuntimeName(String base) {
        int i = 0;
        String name = base;
        while (ServerCore.findRuntime((String)name) != null) {
            name = String.valueOf(base) + " (" + ++i + ")";
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTargetToCloudRuntime(IProject project) {
        try {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt;
            IRuntime srt;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) return false;
            Iterator iterator = facetedProject.getTargetedRuntimes().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((srt = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)(rt = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)iterator.next()))) == null || srt.getRuntimeType() != RUNTIME_TYPE);
            return true;
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean isDebugCloudPortal() {
        return System.getProperty("Oracle.Cloud.Debug.CloudPortal", "false").equals("true");
    }
}

