/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import oracle.eclipse.tools.cloud.JavaServiceConnection;
import oracle.eclipse.tools.cloud.internal.OracleCloudTargetConfigServices;
import oracle.eclipse.tools.cloud.internal.UniqueTargetNameValidationService;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;

public interface IOracleCloudTargetConfig
extends JavaServiceConnection {
    public static final ElementType TYPE = new ElementType(IOracleCloudTargetConfig.class);
    @Type(base=Boolean.class)
    @Derived
    @Service(impl=OracleCloudTargetConfigServices.DebugModeDerivedValueService.class)
    public static final ValueProperty PROP_DEBUG_MODE = new ValueProperty(TYPE, "DebugMode");
    @Label(standard="na&me")
    @Required
    @Documentation(content="The name of the Oracle Cloud instance.")
    @Services(value={@Service(impl=UniqueTargetNameValidationService.class), @Service(impl=OracleCloudTargetConfigServices.NameDefaultValueService.class)})
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Label(standard="&Cloud connection name")
    @Required
    @Services(value={@Service(impl=OracleCloudTargetConfigServices.CloudProfileLabelService1.class), @Service(impl=OracleCloudTargetConfigServices.CloudProfileValueService.class)})
    @Documentation(content="The Cloud connection of the Oracle Java Cloud service instance.")
    public static final ValueProperty PROP_PROFILE_ID = new ValueProperty(TYPE, "ProfileId");
    @Label(standard="Java Cloud Service &URL")
    @Required
    @DependsOn(value={"Service"})
    @Service(impl=OracleCloudTargetConfigServices.ServiceUrlDefaultValueService.class)
    public static final ValueProperty PROP_SERVICE_URL = new ValueProperty(TYPE, "ServiceUrl");
    @Label(standard="&Java Cloud Service name")
    @Required
    @DependsOn(value={"ProfileId"})
    @Services(value={@Service(impl=OracleCloudTargetConfigServices.UniqueJcsInstanceValidationService.class), @Service(impl=OracleCloudTargetConfigServices.JavaServiceNameValueService.class), @Service(impl=OracleCloudTargetConfigServices.JavaServiceNameDefaultValueService.class)})
    @Documentation(content="The service name of your Java service, within your Identity Domain. The name must be unique within the Identity Domain.")
    public static final ValueProperty PROP_SERVICE = new ValueProperty(TYPE, "Service");
    @Type(base=Boolean.class)
    @Label(standard="perform &whitelist scan prior to publish")
    @DefaultValue(text="true")
    @Documentation(content="Enables the white list scan prior to publishing application to Oracle Cloud.")
    public static final ValueProperty PROP_PERFORM_WHITELIST_SCAN_PRIOR_TO_PUBLISH = new ValueProperty(TYPE, "PerformWhitelistScanPriorToPublish");
    @Label(standard="&ignore project build errors when publishing")
    @Type(base=Boolean.class)
    @DefaultValue(text="false")
    @Documentation(content="Specify to continue publishing to Oracle Cloud even if there are build or validation errors in the Java EE project being deployed. For example, some XML validators may require a network connection to retrieve external XML schemas, and if the network is down, a validation error may be flagged. If this option is checked, this error will not prevent you from deploying and running the application.")
    public static final ValueProperty PROP_IGNORE_BUILD_ERROR = new ValueProperty(TYPE, "IgnoreBuildError");

    @Override
    public Value<Boolean> getDebugMode();

    public Value<String> getName();

    public void setName(String var1);

    public Value<String> getProfileId();

    public void setProfileId(String var1);

    public Value<String> getServiceUrl();

    public void setServiceUrl(String var1);

    public Value<String> getService();

    public void setService(String var1);

    public Value<Boolean> getPerformWhitelistScanPriorToPublish();

    public void setPerformWhitelistScanPriorToPublish(String var1);

    public void setPerformWhitelistScanPriorToPublish(Boolean var1);

    public Value<Boolean> isIgnoreBuildError();

    public void setIgnoreBuildError(String var1);

    public void setIgnoreBuildError(Boolean var1);
}

