/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.IOracleCloudTargetConfig;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.cloud.server.internal.NuviaqToolsFactory;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class CloudProfileUtils {
    public static ICloudProfile newProfile() {
        ICloudProfile profile = (ICloudProfile)ICloudProfile.TYPE.instantiate();
        profile.setId("ORACLE_CLOUD_" + System.currentTimeMillis());
        String passwd = System.getProperty("cloud.deployment.password");
        if (passwd != null) {
            profile.setPassword(passwd);
        }
        return profile;
    }

    public static IServer createServer(final ServiceDesc sd) {
        final IServer[] ret = new IServer[1];
        WorkspaceJob job = new WorkspaceJob("Create new cloud server"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IServer server;
                ICloudProfile profile = sd.connection().profile();
                String profileId = (String)profile.getId().content();
                String profileNameBase = (String)profile.getIdentityDomain().content();
                String name = OracleCloudTools.RUNTIME_TYPE.getName();
                name = String.valueOf(name) + " (" + profileNameBase + "-" + sd.getName() + ")";
                IRuntime rt = CloudProfileUtils.findServerRuntimeForProfile(profileId, sd.getName());
                if (rt == null) {
                    String id = OracleCloudTools.findUniqueRuntimeName(name);
                    RuntimeWorkingCopy rtwc = (RuntimeWorkingCopy)OracleCloudTools.RUNTIME_TYPE.createRuntime(id, (IProgressMonitor)new NullProgressMonitor());
                    rtwc.setName(id);
                    OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rtwc.loadAdapter(OracleCloudRuntime.class, monitor));
                    IOracleCloudTargetConfig cfg = crt.getConfig();
                    cfg.setProfileId(profileId);
                    cfg.setService(sd.getName());
                    rt = rtwc.save(true, monitor);
                }
                String serverName = OracleCloudTools.findUniqueServerName(String.valueOf(profileNameBase) + "-" + sd.getName());
                IServerWorkingCopy swc = OracleCloudTools.SERVER_TYPE.createServer(serverName, null, (IProgressMonitor)new NullProgressMonitor());
                swc.setAttribute("auto-publish-setting", 1);
                swc.setName(serverName);
                swc.setRuntime(rt);
                ret[0] = server = swc.save(true, monitor);
                server.loadAdapter(ServerBehaviourDelegate.class, monitor);
                long t1 = System.currentTimeMillis();
                while (server.getServerState() != 2) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 5000L) break;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret[0];
    }

    public static IServer removeServersFor(final ICloudProfile profile) {
        IServer[] ret = new IServer[1];
        WorkspaceJob job = new WorkspaceJob("Delete Cloud server instances.."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    OracleCloudRuntime crt;
                    String profileId = (String)profile.getId().content();
                    IServer[] iServerArray = ServerCore.getServers();
                    int n = iServerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String profileName;
                        IServer s = iServerArray[n2];
                        if (s.getRuntime() != null && (crt = (OracleCloudRuntime)((Object)s.getRuntime().loadAdapter(OracleCloudRuntime.class, monitor))) != null && (profileName = (String)crt.getConfig().getProfileId().content()).equals(profileId)) {
                            s.delete();
                            IRuntime rt = crt.getRuntime();
                            if (rt instanceof IRuntimeWorkingCopy) {
                                rt = ((IRuntimeWorkingCopy)rt).getOriginal();
                            }
                            NuviaqToolsFactory.getInstance().dispose(crt);
                            rt.delete();
                        }
                        ++n2;
                    }
                    iServerArray = ResourceManager.getInstance().getRuntimes();
                    n = iServerArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        String pid;
                        IServer rt = iServerArray[n2];
                        crt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
                        if (crt != null && profileId.equals(pid = (String)crt.getConfig().getProfileId().content())) {
                            rt.delete();
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret[0];
    }

    public static String getSecurePassword(ICloudProfile profile) {
        if (System.getProperty("cloud.deployment.password") != null) {
            return System.getProperty("cloud.deployment.password");
        }
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            String pathName = CloudProfileUtils.getPath(profile);
            if (root.nodeExists(pathName)) {
                ISecurePreferences node = root.node(pathName);
                String passwd = node.get("password", "");
                return passwd;
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public static void saveSecurePassword(ICloudProfile profile, String newPasswd) {
        if (System.getProperty("cloud.deployment.password") != null) {
            return;
        }
        try {
            String pathName = CloudProfileUtils.getPath(profile);
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node(pathName);
            if (newPasswd == null) {
                node.removeNode();
            } else {
                node.put("password", newPasswd, true);
                node.flush();
            }
            root.flush();
        }
        catch (Exception e) {
            CloudPlugin.log(e);
        }
    }

    private static String getPath(ICloudProfile profile) {
        String baseUrl = (String)profile.getBaseUrl().content();
        String profileId = (String)profile.getId().content();
        String pathName = "oracle.eclipse.tools.oepe.server.cloud/" + baseUrl + "/" + profileId;
        return pathName;
    }

    public static IRuntime findServerRuntimeForProfile(String profile, String service) {
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
            if (crt != null) {
                String pid = (String)crt.getConfig().getProfileId().content();
                String sid = (String)crt.getConfig().getService().content();
                if (pid.equals(profile) && sid.equals(service)) {
                    return rt;
                }
            }
            ++n2;
        }
        return null;
    }

    public static List<IServer> findServersForProfile(String profile) {
        ArrayList<IServer> ret = new ArrayList<IServer>();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pid;
            IServer s = iServerArray[n2];
            IRuntime rt = s.getRuntime();
            OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
            if (crt != null && (pid = (String)crt.getConfig().getProfileId().content()).equals(profile)) {
                ret.add(s);
            }
            ++n2;
        }
        return ret;
    }
}

