/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.cloud.ICloudDeploymentListener;
import oracle.eclipse.tools.common.util.PluginUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class CloudPlugin
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.cloud";
    public static final String EXTENSION_POINT_ID = "cloudDeploymentListener";
    private static final Object EL_LISTENER = "listener";
    private static final String ATTR_CLASS = "class";
    private static CloudPlugin plugin;
    private static List<ICloudDeploymentListener> deploymentListeners;

    static {
        deploymentListeners = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CloudPlugin getDefault() {
        return plugin;
    }

    public static final Bundle bundle() {
        return Platform.getBundle((String)PLUGIN_ID);
    }

    public static final IPath state() {
        return Platform.getStateLocation((Bundle)CloudPlugin.bundle());
    }

    public static void log(int severity, String message) {
        CloudPlugin.log(severity, message, null);
    }

    public static void log(int severity, String message, Exception e) {
        Platform.getLog((Bundle)CloudPlugin.bundle()).log((IStatus)new Status(severity, PLUGIN_ID, 0, message, (Throwable)e));
    }

    public static void log(Exception e) {
        CloudPlugin.log(4, "Encountered an unexpected exception.", e);
    }

    public static void logInfo(String msg) {
        CloudPlugin.log(1, msg, null);
    }

    public static void logError(String msg, Exception e) {
        CloudPlugin.log(4, msg, e);
    }

    public static void logWarning(String msg, Exception e) {
        CloudPlugin.log(2, msg, e);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        String message = msg;
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, (Throwable)e);
    }

    public static IStatus createWarningStatus(String msg, Exception e) {
        String message = msg;
        if (message == null) {
            message = "";
        }
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)e);
    }

    public static IStatus createInfoStatus(String msg) {
        String message = msg;
        if (message == null) {
            message = "";
        }
        return new Status(1, PLUGIN_ID, 0, message, null);
    }

    public static synchronized List<ICloudDeploymentListener> getDeploymentListener() {
        if (deploymentListeners == null) {
            deploymentListeners = new ArrayList<ICloudDeploymentListener>();
            for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)PLUGIN_ID, (String)EXTENSION_POINT_ID))) {
                String bundleId = element.getContributor().getName();
                if (!element.getName().equals(EL_LISTENER)) continue;
                try {
                    String className = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                    ICloudDeploymentListener handler = (ICloudDeploymentListener)PluginUtil.instantiate((String)bundleId, (String)className, ICloudDeploymentListener.class);
                    deploymentListeners.add(handler);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
            }
        }
        return deploymentListeners;
    }
}

