/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.io.File;
import java.io.IOException;
import java.util.List;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.CloudProfileUtils;
import oracle.eclipse.tools.cloud.CloudServices;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.internal.GitCommitUtil;
import oracle.eclipse.tools.cloud.profile.ICloudConnections;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.server.internal.NuviaqToolsFactory;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskRepositoryAction;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public final class CloudConnection {
    private final ICloudProfile profile;
    private final CloudServices services = new CloudServices(this);

    public CloudConnection(ICloudProfile profile) {
        this.profile = profile;
    }

    public ICloudProfile profile() {
        return this.profile;
    }

    public void update(ICloudProfile profile) {
        this.profile.copy(profile);
        try {
            this.profile.resource().save();
        }
        catch (Exception e) {
            CloudPlugin.log(e);
        }
        CloudProfileUtils.saveSecurePassword(this.profile, (String)this.profile.getPassword().content());
        for (IServer s : CloudProfileUtils.findServersForProfile((String)profile.getId().content())) {
            IRuntime rt = s.getRuntime();
            try {
                OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.getAdapter(OracleCloudRuntime.class));
                NuviaqToolsFactory.getInstance().dispose(crt);
                NullProgressMonitor monitor = new NullProgressMonitor();
                rt.createWorkingCopy().save(true, (IProgressMonitor)monitor);
            }
            catch (CoreException coreException) {}
        }
        this.services.clear();
    }

    public String name() {
        return (String)this.profile.getConnectionName().content();
    }

    public CloudServices services() {
        return this.services;
    }

    public void remove() {
        if (!this.deleteDevCloudRepositories(this.profile)) {
            return;
        }
        this.profile.setPassword(null);
        CloudProfileUtils.saveSecurePassword(this.profile, null);
        CloudProfileUtils.removeServersFor(this.profile);
        OracleCloudTools.remove(this);
        ICloudConnections conn = (ICloudConnections)this.profile.parent().element();
        conn.getConnections().remove((Object)this.profile);
        try {
            conn.resource().save();
        }
        catch (Exception e) {
            CloudPlugin.log(e);
        }
        this.services.dispose();
    }

    private boolean deleteDevCloudRepositories(ICloudProfile profile) {
        String dcsProjBaseUrl = (String)profile.getDevCloudBaseUrl().content();
        for (TaskRepository taskRepo : TasksUiPlugin.getRepositoryManager().getAllRepositories()) {
            if (!taskRepo.getUrl().startsWith(dcsProjBaseUrl)) continue;
            DeleteTaskRepositoryAction.run((TaskRepository)taskRepo);
        }
        RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
        for (String s : util.getConfiguredRepositories()) {
            try {
                Repository repo = DevCloudCore.findRepository(new File(s));
                RepositoryNode gitLocal = new RepositoryNode(null, repo);
                if (gitLocal == null || GitCommitUtil.deactivateGitRepo(gitLocal, null)) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        final IBuildServer[] buildServerToDelete = new IBuildServer[1];
        final List buildServers = BuildsUi.getModel().getServers();
        for (IBuildServer buildServer : buildServers) {
            if (!buildServer.getUrl().startsWith(dcsProjBaseUrl)) continue;
            buildServerToDelete[0] = buildServer;
            break;
        }
        if (buildServerToDelete[0] != null) {
            UIJob job = new UIJob("Delete build server"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    buildServers.remove(buildServerToDelete[0]);
                    try {
                        BuildsUiInternal.save();
                    }
                    catch (IOException ioe) {
                        CloudPlugin.log(ioe);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return true;
    }
}

