/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.osgi.framework.BundleException;

public class ManifestUtils {
    public static final String MANIFEST_VERSION = "Manifest-Version";
    public static final String MANIFEST_LIST_SEPARATOR = ",\n ";
    public static final String MANIFEST_LINE_SEPARATOR = "\n ";
    private static int MANIFEST_MAXLINE = 511;
    public static final int STATUS_CODE_PLUGIN_CONVERTER_UNAVAILABLE = 201;
    public static final int STATUS_CODE_NOT_A_BUNDLE_MANIFEST = 204;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> loadManifest(File bundleLocation) throws CoreException {
        try {
            Map<String, String> map;
            if (bundleLocation.isFile()) {
                InputStream stream;
                ZipFile jarFile;
                block15: {
                    Map<String, String> map2;
                    block16: {
                        Map map3;
                        jarFile = null;
                        stream = null;
                        try {
                            Map map4;
                            jarFile = new ZipFile(bundleLocation, 1);
                            ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                            if (manifestEntry == null) break block15;
                            stream = jarFile.getInputStream(manifestEntry);
                            if (stream == null || (map4 = ManifestElement.parseBundleManifest((InputStream)stream, null)) == null || !map4.containsKey("Bundle-SymbolicName")) break block16;
                            map3 = map4;
                        }
                        catch (Throwable throwable) {
                            ManifestUtils.closeZipFileAndStream(stream, jarFile);
                            throw throwable;
                        }
                        ManifestUtils.closeZipFileAndStream(stream, jarFile);
                        return map3;
                    }
                    ZipEntry pluginEntry = jarFile.getEntry("plugin.xml");
                    if (pluginEntry == null) {
                        pluginEntry = jarFile.getEntry("fragment.xml");
                    }
                    if (pluginEntry == null || (map2 = ManifestUtils.loadPluginXML(bundleLocation)) == null || !map2.containsKey("Bundle-SymbolicName")) break block15;
                    Map<String, String> map5 = map2;
                    ManifestUtils.closeZipFileAndStream(stream, jarFile);
                    return map5;
                }
                ManifestUtils.closeZipFileAndStream(stream, jarFile);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), null));
            }
            File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
            if (file.exists()) {
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(file);
                    Map map6 = ManifestElement.parseBundleManifest((InputStream)stream, new HashMap(10));
                    if (map6 != null && map6.containsKey("Bundle-SymbolicName")) {
                        Map map7 = map6;
                        return map7;
                    }
                }
                finally {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
            }
            File pxml = new File(bundleLocation, "plugin.xml");
            File fxml = new File(bundleLocation, "fragment.xml");
            if (!pxml.exists()) {
                if (!fxml.exists()) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), null));
            }
            if ((map = ManifestUtils.loadPluginXML(bundleLocation)) == null) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), null));
            if (!map.containsKey("Bundle-SymbolicName")) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), null));
            return map;
        }
        catch (BundleException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), (Throwable)e));
        }
    }

    public static void convertToOSGIFormat(IProject project, String targetVersion, Dictionary<String, String> devProperties) throws CoreException {
        File outputFile = new File(PDEProject.getManifest(project).getLocation().toOSString());
        File inputFile = new File(project.getLocation().toOSString());
        PluginConverter converter = (PluginConverter)PDECore.getDefault().acquireService(PluginConverter.class.getName());
        if (converter == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 201, NLS.bind((String)UtilMessages.ManifestUtils_NeedCompatFragmentToConvertManifest, (Object)project.getLocation()), null));
        }
        try {
            converter.convertManifest(inputFile, outputFile, false, targetVersion, true, devProperties);
        }
        catch (PluginConversionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)UtilMessages.ErrorReadingOldStyleManifest, (Object)inputFile.getAbsolutePath()), (Throwable)e));
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
    }

    public static IPackageFragmentRoot[] findPackageFragmentRoots(IManifestHeader header, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String[] libs = header == null || header.getValue() == null ? new String[]{"."} : header.getValue().split(",");
        IBuild build = ManifestUtils.getBuild(project);
        if (build == null) {
            try {
                return javaProject.getPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {
                return new IPackageFragmentRoot[0];
            }
        }
        LinkedList<IPackageFragmentRoot> pkgFragRoots = new LinkedList<IPackageFragmentRoot>();
        int j = 0;
        while (j < libs.length) {
            String lib = libs[j];
            IPackageFragmentRoot root = null;
            if (!lib.equals(".")) {
                try {
                    root = javaProject.getPackageFragmentRoot((IResource)project.getFile(lib));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return new IPackageFragmentRoot[0];
                }
            }
            if (root != null && root.exists()) {
                pkgFragRoots.add(root);
            } else {
                IBuildEntry entry = build.getEntry("source." + lib);
                if (entry != null) {
                    String[] tokens = entry.getTokens();
                    int i = 0;
                    while (i < tokens.length) {
                        IResource resource = project.findMember(tokens[i]);
                        if (resource != null && (root = javaProject.getPackageFragmentRoot(resource)) != null && root.exists()) {
                            pkgFragRoots.add(root);
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
        return pkgFragRoots.toArray(new IPackageFragmentRoot[pkgFragRoots.size()]);
    }

    public static boolean isImmediateRoot(IPackageFragmentRoot root) throws JavaModelException {
        int kind = root.getKind();
        return kind == 1 || kind == 2 && !root.isExternal();
    }

    public static void writeManifest(Map<String, String> manifestToWrite, Writer out) throws IOException {
        manifestToWrite = new Hashtable<String, String>(manifestToWrite);
        ManifestUtils.writeEntry(out, MANIFEST_VERSION, manifestToWrite.remove(MANIFEST_VERSION));
        ManifestUtils.writeEntry(out, "Bundle-ManifestVersion", manifestToWrite.remove("Bundle-ManifestVersion"));
        ManifestUtils.writeEntry(out, "Bundle-Name", manifestToWrite.remove("Bundle-Name"));
        ManifestUtils.writeEntry(out, "Bundle-SymbolicName", manifestToWrite.remove("Bundle-SymbolicName"));
        ManifestUtils.writeEntry(out, "Bundle-Version", manifestToWrite.remove("Bundle-Version"));
        ManifestUtils.writeEntry(out, "Bundle-ClassPath", manifestToWrite.remove("Bundle-ClassPath"));
        ManifestUtils.writeEntry(out, "Bundle-Activator", manifestToWrite.remove("Bundle-Activator"));
        ManifestUtils.writeEntry(out, "Bundle-Vendor", manifestToWrite.remove("Bundle-Vendor"));
        ManifestUtils.writeEntry(out, "Fragment-Host", manifestToWrite.remove("Fragment-Host"));
        ManifestUtils.writeEntry(out, "Bundle-Localization", manifestToWrite.remove("Bundle-Localization"));
        ManifestUtils.writeEntry(out, "Export-Package", manifestToWrite.remove("Export-Package"));
        ManifestUtils.writeEntry(out, "Provide-Package", manifestToWrite.remove("Provide-Package"));
        ManifestUtils.writeEntry(out, "Require-Bundle", manifestToWrite.remove("Require-Bundle"));
        for (String key : manifestToWrite.keySet()) {
            ManifestUtils.writeEntry(out, key, manifestToWrite.get(key));
        }
        out.flush();
    }

    private static IBuild getBuild(IProject project) {
        IFile buildProps = PDEProject.getBuildProperties(project);
        if (buildProps.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildProps);
            return model.getBuild();
        }
        return null;
    }

    private static Map<String, String> loadPluginXML(File pluginLocation) throws CoreException {
        Dictionary convert;
        if (PDECore.getDefault() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 201, UtilMessages.ManifestUtils_PluginConverterOnlyAvailableWithOSGi, null));
        }
        PluginConverter converter = (PluginConverter)PDECore.getDefault().acquireService(PluginConverter.class.getName());
        if (converter == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 201, NLS.bind((String)UtilMessages.ManifestUtils_NeedCompatFragmentToConvertManifest, (Object)pluginLocation.toString()), null));
        }
        try {
            convert = converter.convertManifest(pluginLocation, false, null, false, null);
        }
        catch (PluginConversionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)UtilMessages.ErrorReadingOldStyleManifest, (Object)pluginLocation.getAbsolutePath()), (Throwable)e));
        }
        if (convert == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)UtilMessages.ErrorReadingOldStyleManifest, (Object)pluginLocation.getAbsolutePath())));
        }
        HashMap<String, String> map = new HashMap<String, String>(convert.size(), 1.0f);
        Enumeration keys = convert.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            map.put(key, (String)convert.get(key));
        }
        return map;
    }

    private static void closeZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
    }

    private static void writeEntry(Writer out, String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            out.write(ManifestUtils.splitOnComma(String.valueOf(key) + ": " + value));
            out.write(10);
        }
    }

    private static String splitOnComma(String value) {
        if (value.length() < MANIFEST_MAXLINE || value.indexOf(MANIFEST_LINE_SEPARATOR) >= 0) {
            return value;
        }
        String[] values = ManifestElement.getArrayFromList((String)value);
        if (values == null || values.length == 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value.length() + (values.length - 1) * MANIFEST_LIST_SEPARATOR.length());
        int i = 0;
        while (i < values.length - 1) {
            sb.append(values[i]).append(MANIFEST_LIST_SEPARATOR);
            ++i;
        }
        sb.append(values[values.length - 1]);
        return sb.toString();
    }
}

