/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.glassfish.ant;

import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public abstract class OepeAdminTask
extends Task {
    String installDir;
    String command;
    String commandStr;

    public OepeAdminTask() {
        this.clearCommand();
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    private void clearCommand() {
        this.setCommand("");
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void addParameter(String name, String value) {
        this.command = String.valueOf(this.command) + String.format(" --%s=%s", name, value);
    }

    public void addCommandOperand(String value) {
        this.command = String.valueOf(this.command) + String.format(" %s", value);
    }

    public void setUser(String user) {
        this.addParameter("user", user);
    }

    public void setPasswordFile(String passwordfile) {
        this.addParameter("passwordfile", passwordfile);
    }

    public void setHost(String host) {
        this.addParameter("host", host);
    }

    public void setPort(String port) {
        this.addParameter("port", port);
    }

    public String getInstallDir() {
        String home;
        Project project;
        if (this.installDir == null && (project = this.getProject()) != null && (home = project.getProperty("asinstall.dir")) != null) {
            return home;
        }
        return this.installDir;
    }

    public void execute() throws BuildException {
        this.execute(this.command);
    }

    public void execute(String commandExec) throws BuildException {
        this.log("Running command " + commandExec);
        String installDirectory = this.getInstallDir();
        if (installDirectory == null) {
            this.log("Install Directory of application server not known. Specify either the installDir attribute or the asinstall.dir property", 1);
            return;
        }
        File f = new File(installDirectory);
        if (!f.exists()) {
            this.log("Glassfish install directory : " + installDirectory + " not found. Specify the correct directory as installDir attribute or asinstall.dir property");
            return;
        }
        try {
            File asadmin = this.getAsAdmin(f);
            String line = String.valueOf(asadmin.getAbsolutePath()) + " " + commandExec;
            CommandLine cmdLine = CommandLine.parse((String)line);
            DefaultExecutor executor = new DefaultExecutor();
            int exitValue = executor.execute(cmdLine);
            this.log(String.format("Process ended with exitValue %d", exitValue));
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
        }
    }

    private File getAsAdmin(File installDir) {
        String os = System.getProperty("os.name");
        File binDir = new File(installDir, "bin");
        if (os.indexOf("Windows") == -1) {
            return new File(binDir, "asadmin");
        }
        return new File(binDir, "asadmin.bat");
    }
}

