/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.glassfish.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JarsForClasspathContainerTask
extends Task {
    private static final Map<String, DefaultContainers> AVAILABLE_SHORT_NAMES;
    private String shortName;
    private String fullPath;
    private String projectName;
    private String toDir;
    private boolean copy;
    private String property;
    private boolean remove;
    private boolean onlyRemoveOnZero;
    private File fileCopyLog;

    static {
        HashMap<String, DefaultContainers> shortNames = new HashMap<String, DefaultContainers>();
        for (DefaultContainers container : EnumSet.allOf(DefaultContainers.class)) {
            shortNames.put(container.getShortName(), container);
        }
        AVAILABLE_SHORT_NAMES = Collections.unmodifiableMap(shortNames);
    }

    public void execute() throws BuildException {
        this.ensureJDTReady();
        this.validateAttributes();
        IPath containerPath = null;
        if (this.shortName != null) {
            containerPath = this.determineDefaultContainer(this.shortName);
        } else if (this.fullPath != null) {
            containerPath = new Path(this.fullPath);
        }
        if (containerPath == null) {
            throw new BuildException("shortName or fullPath to container must be set", this.getLocation());
        }
        if (this.projectName == null) {
            throw new BuildException("projectName must be specified", this.getLocation());
        }
        IProject wsProj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        if (!wsProj.isAccessible()) {
            throw new BuildException(String.format("projectName '%s' refers to a project which closed or not in the workspace", new Object[0]), this.getLocation());
        }
        if (this.copy) {
            try {
                this.doCopy(containerPath, wsProj);
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Exception thrown", (Throwable)e, this.getLocation());
            }
            catch (IOException e) {
                throw new BuildException("Exception thrown", (Throwable)e, this.getLocation());
            }
        } else if (this.remove) {
            try {
                this.doRemove(containerPath, wsProj);
            }
            catch (Exception e) {
                throw new BuildException("Exception thrown", (Throwable)e, this.getLocation());
            }
        } else {
            if (this.property == null) {
                throw new BuildException("Need to specify either property or copy", this.getLocation());
            }
            IClasspathContainer container = this.getContainer(containerPath, wsProj);
            StringBuilder stringBuilder = new StringBuilder();
            IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 1 && "jar".equals((path = entry.getPath()).getFileExtension())) {
                    stringBuilder.append(path.toString());
                    stringBuilder.append(",");
                }
                ++n2;
            }
            if (stringBuilder.length() > 0) {
                if (stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                this.getProject().setProperty(this.property, stringBuilder.toString());
            }
        }
    }

    private void doRemove(IPath containerPath, IProject wsProj) throws FileNotFoundException, IOException {
        if (this.toDir == null) {
            throw new BuildException("toDir must be set", this.getLocation());
        }
        File dir = new File(this.toDir);
        if (!dir.isDirectory()) {
            throw new BuildException(String.format("toDir %s doesn't exist or isn't a directory", dir.toString()), this.getLocation());
        }
        File fileCopyLog = this.getFileCopyLog();
        Properties changeLog = this.loadPropertiesFromFile(fileCopyLog);
        List<File> jarsToActOn = this.jarsToActOn(containerPath, wsProj, dir, new FileActionFilter(){

            @Override
            public boolean includeFile(Properties changeLog, File file) {
                Object object = changeLog.get(file.getName());
                if (object != null) {
                    try {
                        Integer count = Integer.valueOf((String)object);
                        return !JarsForClasspathContainerTask.this.onlyRemoveOnZero || count == 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }, changeLog);
        this.actOnContainerJars(jarsToActOn, dir, new FileAction(){

            @Override
            public void execute(File srcFile, File destDir, Properties changeLog) {
                FileUtils.delete((File)new File(destDir, srcFile.getName()));
                JarsForClasspathContainerTask.this.updateChangeLog(srcFile, -1, changeLog);
            }
        }, changeLog);
        this.storeChangeLog(changeLog);
    }

    private void validateAttributes() {
        if (this.copy && this.remove) {
            throw new BuildException("Can't use 'copy' and 'remove' at the same time", this.getLocation());
        }
        if (this.onlyRemoveOnZero && !this.remove) {
            this.log("onlyRemoveOnZero set but remove is not.  onlyRemoveOnZero will be ignored", 1);
        }
    }

    private IClasspathContainer getContainer(IPath containerPath, IProject wsProj) {
        try {
            IJavaProject javaProj = JavaCore.create((IProject)wsProj);
            return JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProj);
        }
        catch (JavaModelException e) {
            throw new BuildException("JDT model problem", (Throwable)e, this.getLocation());
        }
    }

    private void doCopy(IPath containerPath, IProject wsProj) throws FileNotFoundException, IOException {
        if (this.toDir == null) {
            throw new BuildException("toDir must be set", this.getLocation());
        }
        File dir = new File(this.toDir);
        if (!dir.isDirectory()) {
            throw new BuildException(String.format("toDir %s doesn't exist or isn't a directory", dir.toString()), this.getLocation());
        }
        File fileCopyLog = this.getFileCopyLog();
        Properties changeLog = this.loadPropertiesFromFile(fileCopyLog);
        List<File> jarsToActOn = this.jarsToActOn(containerPath, wsProj, dir, new FileActionFilter(){

            @Override
            public boolean includeFile(Properties changeLog, File file) {
                return true;
            }
        }, changeLog);
        this.actOnContainerJars(jarsToActOn, dir, new FileAction(){

            @Override
            public void execute(File srcFile, File destDir, Properties changeLog) {
                try {
                    FileUtils.getFileUtils().copyFile(srcFile, new File(destDir, srcFile.getName()));
                    JarsForClasspathContainerTask.this.updateChangeLog(srcFile, 1, changeLog);
                }
                catch (IOException e) {
                    JarsForClasspathContainerTask.this.log(String.format("Warning %s failed to copy due to %s", destDir.getName(), e.getLocalizedMessage()));
                }
            }
        }, changeLog);
        this.storeChangeLog(changeLog);
    }

    private void storeChangeLog(Properties changeLog) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.getFileCopyLog());
            changeLog.store(os, "");
        }
        catch (Throwable throwable) {
            FileUtils.close(os);
            throw throwable;
        }
        FileUtils.close((OutputStream)os);
    }

    private void updateChangeLog(File file, int incrementValue, Properties props) {
        String name = file.getName();
        int count = 1;
        Object object = props.get(name);
        if (object != null) {
            try {
                Integer savedValue = Integer.valueOf((String)object);
                if (savedValue != null) {
                    count = savedValue + incrementValue;
                }
            }
            catch (NumberFormatException savedValue) {
                // empty catch block
            }
        }
        String key = name;
        if (count > 0) {
            props.setProperty(name, Integer.toString(count));
        } else {
            props.remove(key);
        }
    }

    private List<File> jarsToActOn(IPath containerPath, IProject wsProject, File dir, FileActionFilter filter, Properties changeLog) {
        ArrayList<File> files = new ArrayList<File>();
        IClasspathContainer container = this.getContainer(containerPath, wsProject);
        IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            IPath path;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 1 && "jar".equals((path = entry.getPath()).getFileExtension()) && (file = path.toFile()).exists() && filter.includeFile(changeLog, file)) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }

    private void actOnContainerJars(List<File> filesToActOn, File dir, FileAction runnable, Properties changeLog) {
        for (File file : filesToActOn) {
            runnable.execute(file, dir, changeLog);
        }
    }

    private File getFileCopyLog() {
        if (this.fileCopyLog == null) {
            this.fileCopyLog = new File(this.toDir, ".oepe.filecopy.log");
        }
        return this.fileCopyLog;
    }

    private Properties loadPropertiesFromFile(File fileCopyLog) throws FileNotFoundException, IOException {
        FileInputStream is = null;
        Properties props = new Properties();
        try {
            if (fileCopyLog.exists()) {
                is = new FileInputStream(fileCopyLog);
                props.load(is);
                FileUtils.close((InputStream)is);
                is = null;
            }
            Properties properties = props;
            return properties;
        }
        finally {
            FileUtils.close(is);
        }
    }

    private void ensureJDTReady() {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (OperationCanceledException e) {
            throw new BuildException("Failed while waiting for auto build", (Throwable)e, this.getLocation());
        }
        catch (InterruptedException e) {
            throw new BuildException("Failed while waiting for auto build", (Throwable)e, this.getLocation());
        }
    }

    private IPath determineDefaultContainer(String selectedShortName) {
        if (!AVAILABLE_SHORT_NAMES.containsKey(selectedShortName)) {
            throw new BuildException(String.format("'%s' specified for shortName but this is not a supported default container. Possibilities are: %s", this.shortName, AVAILABLE_SHORT_NAMES.keySet()), this.getLocation());
        }
        return new Path(AVAILABLE_SHORT_NAMES.get(selectedShortName).getFullPath());
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setToDir(String toDir) {
        this.toDir = toDir;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public void setOnlyRemoveOnZero(boolean onlyRemoveOnZero) {
        this.onlyRemoveOnZero = onlyRemoveOnZero;
    }

    private static enum DefaultContainers {
        ADF_ESSENTIALS_CORE("adfe-core", "oracle.eclipse.tools.adfessentials.libraries/oracle.eclipse.tools.adfessentials.core"),
        ADF_ESSENTIALS_CLIENT("adfe-client", "oracle.eclipse.tools.adfessentials.libraries/oracle.eclipse.tools.adfessentials.client"),
        ADF_ESSENTIALS_CORE_EXTRAS("adfe-core-extra", "oracle.eclipse.tools.adfessentials.libraries/oracle.eclipse.tools.adfessentials.core.extra");

        private final String fullPath;
        private final String shortName;

        private DefaultContainers(String shortName, String fullPath) {
            this.fullPath = fullPath;
            this.shortName = shortName;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String getShortName() {
            return this.shortName;
        }
    }

    private static abstract class FileAction {
        private FileAction() {
        }

        public abstract void execute(File var1, File var2, Properties var3);
    }

    private static abstract class FileActionFilter {
        private FileActionFilter() {
        }

        public abstract boolean includeFile(Properties var1, File var2);
    }
}

