/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.ui.validation;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.webtier.jsp.ui.validation.OepeValidationMessageFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class OepeValidationReporter
implements IJSFViewValidator.IValidationReporter {
    private final IValidator _validator;
    private final IReporter _reporter;
    private final IFile _file;
    private final OepeValidationMessageFactory _factory;
    private final Set<Integer> _ignoreSet;

    public OepeValidationReporter(IValidator validator, IReporter reporter, IFile file) {
        this._validator = validator;
        this._reporter = reporter;
        this._file = file;
        this._factory = new OepeValidationMessageFactory();
        this._ignoreSet = new HashSet<Integer>();
        this.addIgnoreCode(27);
        this.addIgnoreCode(5);
        this.addIgnoreCode(2);
        this.addIgnoreCode(28);
        this.addIgnoreCode(9);
        this.addIgnoreCode(8);
        this.addIgnoreCode(14);
        this.addIgnoreCode(13);
        this.addIgnoreCode(17);
    }

    private void addIgnoreCode(int ignoreValue) {
        this._ignoreSet.add(ignoreValue);
    }

    public void report(Diagnostic problem, int start, int length) {
        if (this.shouldIgnore(problem)) {
            return;
        }
        Message message = this._factory.createFromDiagnostic(problem, start, length, this._file);
        if ((message.getSeverity() & 7) != 0) {
            this._reporter.addMessage(this._validator, (IMessage)message);
        }
    }

    private boolean shouldIgnore(Diagnostic problem) {
        Integer code = problem.getCode();
        return this._ignoreSet.contains(code);
    }

    public void report(IMessage message) {
        if ((message.getSeverity() & 7) != 0) {
            this._reporter.addMessage(this._validator, message);
        }
    }
}

