/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.ui.hyperlink;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.ui.hyperlink.IHyperlinkProvider;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.JavaResourceBundleReference;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.JavaResourceBundleReferenceLocation;
import oracle.eclipse.tools.webtier.jsp.jsptagbase.provider.JsptagbaseEditPlugin;
import oracle.eclipse.tools.webtier.jsp.ui.hyperlink.Messages;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class BundleReferenceAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof JavaResourceBundleReference && IHyperlinkProvider.class.isAssignableFrom(adapterType)) {
            final JavaResourceBundleReference reference = (JavaResourceBundleReference)adaptableObject;
            return new IHyperlinkProvider(){

                public Set<IHyperlink> getHyperlinks(IRegion region) {
                    if (reference.getTargetArtifact() instanceof ResourceArtifact) {
                        return Collections.singleton(new BundleHyperlink(reference, region));
                    }
                    return Collections.emptySet();
                }
            };
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IHyperlink.class};
    }

    private static class BundleHyperlink
    implements IHyperlink {
        private final JavaResourceBundleReference reference;
        private final IRegion region;

        public BundleHyperlink(JavaResourceBundleReference reference, IRegion region) {
            this.reference = reference;
            this.region = region;
        }

        public void open() {
            block23: {
                IFile file;
                IResource res;
                ResourceLocation loc;
                IArtifact targetArtifact = this.reference.getTargetArtifact();
                if (targetArtifact != null && (loc = targetArtifact.getLocation()) != null && (res = loc.getResource()) != null && res.getType() == 1 && (file = (IFile)res) != null && file.exists()) {
                    IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = null;
                    if (workbench != null) {
                        page = workbench.getActivePage();
                    }
                    if (page != null) {
                        try {
                            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                            String keyName = this.getBundleKey();
                            if (keyName == null || keyName.length() <= 0) break block23;
                            IEditorInput editorInput = editorPart.getEditorInput();
                            IDocument document = null;
                            if (editorPart instanceof ITextEditor) {
                                document = ((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)editorInput);
                            } else {
                                IPath path = file.getFullPath();
                                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                                manager.connect(path, LocationKind.IFILE, null);
                                try {
                                    ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                                    if (buffer != null) {
                                        document = buffer.getDocument();
                                    }
                                }
                                finally {
                                    manager.disconnect(path, LocationKind.IFILE, null);
                                }
                            }
                            boolean found = false;
                            IRegion foundRegion = null;
                            if (document != null) {
                                String key = PropertyFileDocumentModel.escape((String)keyName, (boolean)false);
                                int offset = document.getLength() - 1;
                                try {
                                    FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
                                    PropertyKeyHyperlinkDetector detector = new PropertyKeyHyperlinkDetector();
                                    detector.setContext((IAdaptable)editorPart);
                                    while (!found && offset >= 0) {
                                        foundRegion = finder.find(offset, key, false, true, false, false);
                                        if (foundRegion == null) {
                                            offset = -1;
                                            continue;
                                        }
                                        IHyperlink[] hyperlinks = detector.detectHyperlinks(null, foundRegion, false);
                                        if (hyperlinks != null) {
                                            int i = 0;
                                            while (i < hyperlinks.length) {
                                                IRegion hyperlinkRegion = hyperlinks[i].getHyperlinkRegion();
                                                found = key.equals(document.get(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength()));
                                                ++i;
                                            }
                                        } else if (document instanceof IDocumentExtension3) {
                                            ITypedRegion partition = null;
                                            partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", foundRegion.getOffset(), false);
                                            found = "__dftl_partition_content_type".equals(partition.getType()) && key.equals(document.get(partition.getOffset(), partition.getLength()).trim());
                                        }
                                        offset = offset == foundRegion.getOffset() ? -1 : foundRegion.getOffset();
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    found = false;
                                }
                                catch (BadPartitioningException badPartitioningException) {
                                    found = false;
                                }
                            }
                            if (found) {
                                EditorUtility.revealInEditor((IEditorPart)editorPart, foundRegion);
                            }
                        }
                        catch (PartInitException e) {
                            LoggingService.logException((Plugin)JsptagbaseEditPlugin.getPlugin(), (CoreException)((Object)e));
                        }
                        catch (CoreException e) {
                            LoggingService.logException((Plugin)JsptagbaseEditPlugin.getPlugin(), (CoreException)e);
                        }
                    }
                }
            }
        }

        public String getTypeLabel() {
            return this.getBundleKey();
        }

        private String getBundleKey() {
            for (IArtifactReferenceLocation location : this.reference.getLocations()) {
                Range range;
                if (!(location instanceof JavaResourceBundleReferenceLocation) || (range = location.getResourceLocation().getRange()) == null || !range.contains((long)this.region.getOffset())) continue;
                return ((JavaResourceBundleReferenceLocation)location).getBundleKey();
            }
            return "";
        }

        public String getHyperlinkText() {
            IResource resource;
            ResourceLocation location;
            IArtifact bundleArtifact = this.reference.getTargetArtifact();
            String bundleFileName = null;
            if (bundleArtifact != null && (location = bundleArtifact.getLocation()) != null && (resource = location.getResource()) != null) {
                bundleFileName = resource.getName();
            }
            return bundleFileName == null ? Messages.BundleReferenceAdapterFactory_Open : NLS.bind((String)Messages.BundleReferenceAdapterFactory_OpenIn, bundleFileName);
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }
    }
}

