/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.swt.graphics.Image;

public final class ValueLabelProvider
implements ILabelProvider {
    private final PropertyEditorPart part;
    private final LocalizationService localizationService;
    private final ValueLabelService valueLabelService;
    private final ValueImageService valueImageService;

    public ValueLabelProvider(PropertyEditorPart part, ValueProperty property) {
        this(part, (ValueLabelService)property.service(ValueLabelService.class), (ValueImageService)property.service(ValueImageService.class));
    }

    public ValueLabelProvider(PropertyEditorPart part, Value<?> property) {
        this(part, (ValueLabelService)property.service(ValueLabelService.class), (ValueImageService)property.service(ValueImageService.class));
    }

    private ValueLabelProvider(PropertyEditorPart part, ValueLabelService valueLabelService, ValueImageService valueImageService) {
        if (part == null) {
            throw new IllegalArgumentException();
        }
        this.part = part;
        this.localizationService = (LocalizationService)this.part.definition().adapt(LocalizationService.class);
        this.valueLabelService = valueLabelService;
        this.valueImageService = valueImageService;
    }

    public String getText(Object element) {
        String value = (String)element;
        String label = null;
        try {
            label = this.valueLabelService.provide(value);
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        if (label == null) {
            label = value;
        } else if (!label.equals(value)) {
            label = this.localizationService.transform(label, CapitalizationType.FIRST_WORD_ONLY, false);
        }
        return label;
    }

    public Image getImage(Object element) {
        ImageData imageData = this.getImageData(element);
        Image image = null;
        if (imageData != null) {
            image = this.part.getSwtResourceCache().image(imageData);
        }
        return image;
    }

    public ImageData getImageData(Object element) {
        ImageData imageData = null;
        try {
            imageData = this.valueImageService.provide((String)element);
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return imageData;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

