/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class SapphireActionPresentation {
    private final SapphireActionPresentationManager manager;
    private final List<SapphireActionHandlerFilter> filters = new CopyOnWriteArrayList<SapphireActionHandlerFilter>();

    public SapphireActionPresentation(SapphireActionPresentationManager manager) {
        this.manager = manager;
        manager.addPresentation(this);
    }

    public final SapphireActionPresentationManager getManager() {
        return this.manager;
    }

    public final List<SapphireAction> getActions() {
        ArrayList<SapphireAction> actions = new ArrayList<SapphireAction>();
        for (SapphireAction action : this.getManager().getActions()) {
            if (!this.hasActionHandlers(action)) continue;
            actions.add(action);
        }
        return Collections.unmodifiableList(actions);
    }

    public final boolean hasActions() {
        for (SapphireAction action : this.getManager().getActions()) {
            if (!this.hasActionHandlers(action)) continue;
            return true;
        }
        return false;
    }

    public final List<SapphireActionHandler> getActionHandlers(SapphireAction action) {
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        for (SapphireActionHandler handler : action.getActiveHandlers()) {
            boolean ok = true;
            ArrayList<SapphireActionHandlerFilter> failedFilters = null;
            for (SapphireActionHandlerFilter filter : this.filters) {
                try {
                    ok = filter.check(handler);
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    if (failedFilters == null) {
                        failedFilters = new ArrayList<SapphireActionHandlerFilter>();
                    }
                    failedFilters.add(filter);
                }
                if (!ok) break;
            }
            if (failedFilters != null) {
                this.filters.removeAll(failedFilters);
            }
            if (!ok) continue;
            handlers.add(handler);
        }
        return Collections.unmodifiableList(handlers);
    }

    public final boolean hasActionHandlers(SapphireAction action) {
        for (SapphireActionHandler handler : action.getActiveHandlers()) {
            boolean ok = true;
            ArrayList<SapphireActionHandlerFilter> failedFilters = null;
            for (SapphireActionHandlerFilter filter : this.filters) {
                try {
                    ok = filter.check(handler);
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    if (failedFilters == null) {
                        failedFilters = new ArrayList<SapphireActionHandlerFilter>();
                    }
                    failedFilters.add(filter);
                }
                if (!ok) break;
            }
            if (failedFilters != null) {
                this.filters.removeAll(failedFilters);
            }
            if (!ok) continue;
            return true;
        }
        return false;
    }

    public final void addFilter(SapphireActionHandlerFilter filter) {
        this.filters.add(filter);
    }

    public final void removeFilter(SapphireActionHandlerFilter filter) {
        this.filters.remove(filter);
    }

    public abstract void render();

    public abstract boolean displayActionHandlerChoice(SapphireAction var1);

    protected final MenuItem renderMenuItem(Menu menu, final SapphireActionHandler handler) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setEnabled(handler.isEnabled());
        menuItem.setText(LabelTransformer.transform((String)handler.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
        this.setMenuItemImage(menuItem, handler);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                handler.execute(SapphireActionPresentation.this.getManager().context());
            }
        });
        final Listener handlerListener = new Listener(){

            public void handle(final Event event) {
                Runnable op = new Runnable(){

                    @Override
                    public void run() {
                        if (Display.getCurrent() == null) {
                            Display.getDefault().asyncExec((Runnable)this);
                            return;
                        }
                        if (event instanceof SapphireActionSystemPart.LabelChangedEvent) {
                            menuItem.setText(LabelTransformer.transform((String)handler.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
                        } else if (event instanceof SapphireActionSystemPart.ImagesChangedEvent) {
                            SapphireActionPresentation.this.setMenuItemImage(menuItem, handler);
                        } else if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                            menuItem.setEnabled(handler.isEnabled());
                        }
                    }
                };
                op.run();
            }
        };
        handler.attach(handlerListener);
        menuItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                handler.detach(handlerListener);
            }
        });
        return menuItem;
    }

    protected void setMenuItemImage(MenuItem menuItem, SapphireActionHandler handler) {
        Image image = null;
        ImageData imageData = handler.getImage(16);
        if (imageData != null) {
            image = ((SwtPresentation)this.getManager().context()).resources().image(imageData);
        }
        menuItem.setImage(image);
    }

    public void dispose() {
    }
}

