/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.Collections;
import java.util.Set;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDefaultActionDef;

public class DiagramNodeDefaultActionPart
extends SapphirePart {
    private IDiagramNodeDefaultActionDef definition;
    private SapphireActionHandler actionHandler;
    private String label;
    private String description;

    @Override
    protected void init() {
        super.init();
        this.definition = (IDiagramNodeDefaultActionDef)((SapphirePart)this).definition;
        String actionId = (String)this.definition.getActionId().content();
        String actionHandlerId = (String)this.definition.getActionHandlerId().content();
        SapphireAction action = this.getAction(actionId);
        this.label = this.definition.getLabel().localized(CapitalizationType.FIRST_WORD_ONLY, false);
        this.description = this.definition.getLabel().localized(CapitalizationType.NO_CAPS, false);
        if (actionHandlerId == null) {
            this.actionHandler = action.getFirstActiveHandler();
        } else {
            for (SapphireActionHandler h : action.getActiveHandlers()) {
                if (!h.getId().equalsIgnoreCase(actionHandlerId)) continue;
                this.actionHandler = h;
                break;
            }
        }
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Diagram.Node");
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public SapphireActionHandler getActionHandler() {
        return this.actionHandler;
    }
}

