/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.SapphirePart;

public abstract class Presentation {
    private SapphirePart part;
    private Presentation parent;
    private List<Listener> partListeners;

    public Presentation(SapphirePart part, Presentation parent) {
        if (part == null) {
            throw new IllegalArgumentException();
        }
        this.part = part;
        this.parent = parent;
    }

    public SapphirePart part() {
        return this.part;
    }

    public Presentation parent() {
        return this.parent;
    }

    public abstract void render();

    protected final void attachPartListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.partListeners == null) {
            this.partListeners = new ArrayList<Listener>(1);
        }
        this.partListeners.add(listener);
        this.part.attach(listener);
    }

    public void dispose() {
        this.parent = null;
        if (this.partListeners != null) {
            for (Listener listener : this.partListeners) {
                this.part.detach(listener);
            }
            this.partListeners = null;
        }
        this.part = null;
    }

    public final boolean disposed() {
        return this.part == null;
    }
}

