/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor.config.impl;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSIFileNotFoundException;
import org.eclipse.wst.wsi.internal.core.common.impl.AddStyleSheetImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.ManInTheMiddle;
import org.eclipse.wst.wsi.internal.core.monitor.config.MonitorConfig;
import org.eclipse.wst.wsi.internal.core.monitor.config.MonitorConfigReader;
import org.eclipse.wst.wsi.internal.core.monitor.config.Redirect;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.CommentImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.ManInTheMiddleImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.MonitorConfigImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.RedirectImpl;
import org.eclipse.wst.wsi.internal.core.util.MessageList;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MonitorConfigReaderImpl
implements MonitorConfigReader {
    protected MessageList messageList = null;
    protected String documentURI;

    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    public MonitorConfig readMonitorConfig(String monitorConfigURI) throws WSIException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(monitorConfigURI);
        }
        catch (FileNotFoundException fnfe) {
            throw new WSIFileNotFoundException(this.getMessage("config02", monitorConfigURI, "Could not find file:"), fnfe);
        }
        catch (Exception e) {
            throw new WSIException(this.getMessage("config03", monitorConfigURI, "Could not read file:"), e);
        }
        return this.readMonitorConfig(fileReader);
    }

    public MonitorConfig readMonitorConfig(Reader reader) throws WSIException {
        MonitorConfigImpl monitorConfig = new MonitorConfigImpl();
        Document doc = XMLUtils.parseXML(reader);
        this.parseConfigElement(monitorConfig, doc.getDocumentElement());
        return monitorConfig;
    }

    public String getLocation() {
        return this.documentURI;
    }

    public void setLocation(String documentURI) {
        this.documentURI = documentURI;
    }

    private void parseConfigElement(MonitorConfig monitorConfig, Element element) throws WSIException {
        Element nextElement = XMLUtils.getFirstChild(element);
        boolean isLogDurationDefine = false;
        boolean isCleanupTimeoutSecondsDefine = false;
        while (nextElement != null) {
            if (this.isElement(nextElement, "logFile")) {
                this.parseLogFileElement(monitorConfig, nextElement);
            } else if (this.isElement(nextElement, "logDuration")) {
                monitorConfig.setLogDuration(this.getIntValue(nextElement));
                if (monitorConfig.getLogDuration() < 0) {
                    throw new IllegalArgumentException(this.getMessage("config09", "logDuration", "Parameter value can't be negative. Element name:"));
                }
                isLogDurationDefine = true;
            } else if (this.isElement(nextElement, "cleanupTimeoutSeconds")) {
                monitorConfig.setTimeout(this.getIntValue(nextElement));
                if (monitorConfig.getTimeout() < 0) {
                    throw new IllegalArgumentException(this.getMessage("config09", "cleanupTimeoutSeconds", "Parameter value can't be negative. Element name:"));
                }
                isCleanupTimeoutSecondsDefine = true;
            } else if (this.isElement(nextElement, "manInTheMiddle")) {
                ManInTheMiddleImpl manInTheMiddle = new ManInTheMiddleImpl();
                monitorConfig.setManInTheMiddle(manInTheMiddle);
                this.parseManInTheMiddleElement(manInTheMiddle, nextElement);
            } else if (this.isElement(nextElement, "comment")) {
                CommentImpl comment = new CommentImpl();
                comment.setText(XMLUtils.getText(nextElement));
                monitorConfig.setComment(comment);
            }
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
        if (!isLogDurationDefine) {
            throw new IllegalArgumentException(this.getMessage("config10", "logDuration", "Element is missing. Element name:"));
        }
        if (!isCleanupTimeoutSecondsDefine) {
            throw new IllegalArgumentException(this.getMessage("config10", "cleanupTimeoutSeconds", "Element is missing. Element name:"));
        }
    }

    private void parseLogFileElement(MonitorConfig monitorConfig, Element element) throws WSIException {
        monitorConfig.setLogLocation(XMLUtils.getAttributeValue(element, "location"));
        monitorConfig.setReplaceLog(XMLUtils.getBooleanValue(element, "replace", false));
        Element nextElement = XMLUtils.getFirstChild(element);
        while (nextElement != null) {
            if (this.isElement(nextElement, "addStyleSheet")) {
                AddStyleSheetImpl addStyleSheet = new AddStyleSheetImpl();
                TestUtils.parseAddStyleSheet(nextElement, addStyleSheet, "../common/xsl/log.xsl");
                monitorConfig.setAddStyleSheet(addStyleSheet);
            }
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
    }

    private void parseManInTheMiddleElement(ManInTheMiddle manInTheMiddle, Element element) throws WSIException {
        Element nextElement = XMLUtils.getFirstChild(element);
        while (nextElement != null) {
            if (this.isElement(nextElement, "redirect")) {
                RedirectImpl redirect = new RedirectImpl();
                manInTheMiddle.addRedirect(redirect);
                this.parseRedirectElement(redirect, nextElement);
            } else if (this.isElement(nextElement, "comment")) {
                CommentImpl comment = new CommentImpl();
                comment.setText(XMLUtils.getText(nextElement));
                manInTheMiddle.setComment(comment);
            }
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
    }

    private void parseRedirectElement(Redirect redirect, Element element) throws WSIException {
        Element nextElement = XMLUtils.getFirstChild(element);
        boolean isListenPortDefine = false;
        boolean isSchemeAndHostPortDefine = false;
        boolean isMaxConnectionsDefine = false;
        boolean isReadTimeoutSecondsDefine = false;
        while (nextElement != null) {
            if (this.isElement(nextElement, "listenPort")) {
                redirect.setListenPort(this.getIntValue(nextElement));
                isListenPortDefine = true;
            } else if (this.isElement(nextElement, "schemeAndHostPort")) {
                redirect.setHost(XMLUtils.getText(nextElement));
                isSchemeAndHostPortDefine = true;
            } else if (this.isElement(nextElement, "maxConnections")) {
                redirect.setMaxConnections(this.getIntValue(nextElement));
                isMaxConnectionsDefine = true;
            } else if (this.isElement(nextElement, "readTimeoutSeconds")) {
                redirect.setReadTimeoutSeconds(this.getIntValue(nextElement));
                if (redirect.getReadTimeoutSeconds() < 0) {
                    throw new IllegalArgumentException(this.getMessage("config09", "readTimeoutSeconds", "Parameter value can't be negative. Element name:"));
                }
                isReadTimeoutSecondsDefine = true;
            } else if (this.isElement(nextElement, "comment")) {
                CommentImpl comment = new CommentImpl();
                comment.setText(XMLUtils.getText(nextElement));
                redirect.setComment(comment);
            }
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
        if (!isListenPortDefine) {
            throw new IllegalArgumentException(this.getMessage("config10", "listenPort", "Element is missing. Element name:"));
        }
        if (!isSchemeAndHostPortDefine) {
            throw new IllegalArgumentException(this.getMessage("config10", "schemeAndHostPort", "Element is missing. Element name:"));
        }
        if (!isMaxConnectionsDefine) {
            throw new IllegalArgumentException(this.getMessage("config10", "maxConnections", "Element is missing. Element name:"));
        }
        if (!isReadTimeoutSecondsDefine) {
            throw new IllegalArgumentException(this.getMessage("config10", "readTimeoutSeconds", "Element is missing. Element name:"));
        }
    }

    private boolean isElement(Element element, String localName) {
        return this.isElement(element, "http://www.ws-i.org/testing/2004/07/monitorConfig/", localName);
    }

    private boolean isElement(Element element, String namespace, String localName) {
        return XMLUtils.isElement(element, namespace, localName);
    }

    private int getIntValue(Element element) throws WSIException {
        String intValue = null;
        intValue = XMLUtils.getText(element);
        if (intValue == null) {
            throw new WSIException(this.getMessage("config04", String.valueOf(element.getLocalName()) + "Element must contain an integer value:"));
        }
        int returnValue = Integer.valueOf(intValue);
        return returnValue;
    }

    private String getMessage(String messageID, String defaultMessage) {
        return this.getMessage(messageID, null, defaultMessage);
    }

    private String getMessage(String messageID, String messageData, String defaultMessage) {
        String message = defaultMessage;
        message = this.messageList != null ? this.messageList.getMessage(messageID, messageData, defaultMessage) : String.valueOf(message) + " " + messageData + ".";
        return message;
    }
}

