/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.utils.pem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import oracle.cloudlogic.javaservice.utils.EncodingUtil;
import oracle.cloudlogic.javaservice.utils.pem.PemFileHeader;
import oracle.cloudlogic.javaservice.utils.pem.PemFileObject;

public class PemFileReader
extends BufferedReader {
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";

    public PemFileReader(Reader reader) {
        super(reader);
    }

    public PemFileObject readPemObject() throws IOException {
        String line = this.readLine();
        if (line != null && line.startsWith(BEGIN)) {
            line = line.substring(BEGIN.length());
            int index = line.indexOf(45);
            String type = line.substring(0, index);
            if (index > 0) {
                return this.loadObject(type);
            }
        }
        return null;
    }

    private PemFileObject loadObject(String type) throws IOException {
        String line;
        String endMarker = END + type;
        StringBuffer buf = new StringBuffer();
        ArrayList<PemFileHeader> headers = new ArrayList<PemFileHeader>();
        while ((line = this.readLine()) != null) {
            if (line.indexOf(":") >= 0) {
                int index = line.indexOf(58);
                String hdr = line.substring(0, index);
                String value = line.substring(index + 1).trim();
                headers.add(new PemFileHeader(hdr, value));
                continue;
            }
            if (line.indexOf(endMarker) != -1) break;
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return new PemFileObject(type, headers, EncodingUtil.decodetoByteArray(buf.toString()));
    }
}

