/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.spi;

import java.util.List;

public class Property {
    private String name;
    private String description;
    private boolean mandatory = true;
    private boolean nullStringAllowed = false;
    private Object defaultValue;
    private PropertyType parameterType = new StringOptionType(CardinalityEnum.one, null, null);

    public Property(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isNullStringAllowed() {
        return this.nullStringAllowed;
    }

    public void setNullStringAllowed(boolean nullStringAllowed) {
        this.nullStringAllowed = nullStringAllowed;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String Object2) {
        this.defaultValue = Object2;
    }

    public PropertyType getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(PropertyType parameterType) {
        this.parameterType = parameterType;
    }

    public static class StringOptionType
    implements PropertyType {
        private Cardinality cardinality = new Cardinality();
        private String[] enumValues;

        public StringOptionType(CardinalityEnum value, String delimiter, String[] enumValues) {
            this.cardinality.setValue(value);
            this.cardinality.setDelimiter(delimiter);
            if (enumValues != null) {
                enumValues = (String[])enumValues.clone();
            }
            this.enumValues = enumValues;
        }

        public Cardinality getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(Cardinality card) {
            this.cardinality = card;
        }

        public String[] getEnumValues() {
            if (this.enumValues == null) {
                return null;
            }
            return (String[])this.enumValues.clone();
        }

        public void setEnumValues(String[] enumValues) {
            if (enumValues != null) {
                enumValues = (String[])enumValues.clone();
            }
            this.enumValues = enumValues;
        }

        public CardinalityEnum getCardinalityEnum() {
            return this.cardinality.getValue();
        }
    }

    public static class PasswordType
    extends SingleOptionType {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileOptionType
    implements PropertyType {
        private Cardinality cardinality = new Cardinality();
        private FileTypesType fileTypes;

        public FileOptionType(CardinalityEnum value, String delimiter, List<FileExt> fileTypes, boolean directoryOk, boolean fileOk) {
            this.cardinality.setValue(value);
            this.cardinality.setDelimiter(delimiter);
            this.fileTypes = new FileTypesType();
            this.fileTypes.setDirectoryOk(directoryOk);
            this.fileTypes.setFileOk(fileOk);
            this.fileTypes.setFileTypes(fileTypes);
        }

        @Override
        public CardinalityEnum getCardinalityEnum() {
            return this.cardinality.getValue();
        }

        public Cardinality getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(Cardinality card) {
            this.cardinality = card;
        }

        public FileTypesType getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(FileTypesType fileTypes) {
            this.fileTypes = fileTypes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileTypesType {
        private List<FileExt> fileTypes;
        private boolean directoryOk;
        private boolean fileOk;

        public List<FileExt> getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(List<FileExt> fileTypes) {
            this.fileTypes = fileTypes;
        }

        public boolean isDirectoryOk() {
            return this.directoryOk;
        }

        public void setDirectoryOk(boolean directory) {
            this.directoryOk = directory;
        }

        public void setFileOk(boolean fileOk) {
            this.fileOk = fileOk;
        }

        public boolean isFileOk() {
            return this.fileOk;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileExt {
        ear,
        war,
        jar,
        zip,
        none,
        xml,
        properties,
        jks;

    }

    public static class Cardinality {
        private CardinalityEnum value;
        private String delimiter;

        public CardinalityEnum getValue() {
            return this.value;
        }

        public void setValue(CardinalityEnum value) {
            this.value = value;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CardinalityEnum {
        one,
        many;

    }

    public static final class PropertiesOptionType
    extends SingleOptionType {
    }

    public static final class NumberOptionType
    extends SingleOptionType {
    }

    public static final class DateOptionType
    extends SingleOptionType {
    }

    public static final class BooleanOptionType
    extends SingleOptionType {
    }

    public static class SingleOptionType
    implements PropertyType {
        public CardinalityEnum getCardinalityEnum() {
            return CardinalityEnum.one;
        }
    }

    public static interface PropertyType {
        public CardinalityEnum getCardinalityEnum();
    }
}

