/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cloudlogic.javaservice.common.api.exception.DuplicateResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.ResourcePermissionException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.resource.fileaccess.FileAccessShellService;
import oracle.cloudlogic.javaservice.types.FilePathType;
import oracle.cloudlogic.javaservice.types.FolderPathType;
import oracle.cloudlogic.javaservice.types.PathType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;
import oracle.cloudlogic.javaservice.utils.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAccessShellServiceImpl
implements FileAccessShellService {
    private String pwd = new File("./").getAbsolutePath();
    private String lastPath = null;
    static Map<String, String> mimetuype = new HashMap<String, String>();

    private String toMimeType(String path) {
        if (path == null) {
            path = "";
        }
        int last = path.lastIndexOf(".");
        String ext = null;
        ext = last >= 0 ? path.substring(last + 1, path.length()) : "*";
        String ret = mimetuype.get(ext.toLowerCase());
        if (ret == null) {
            return mimetuype.get("*");
        }
        return ret;
    }

    public FileAccessShellServiceImpl(String root) {
        this.pwd = root == null ? new File("./").getAbsolutePath() : new File(root).getAbsolutePath();
        this.lastPath = this.pwd;
    }

    @Override
    public boolean isPendingServerRestart() throws ServiceException {
        throw new ServiceException("Unimplemented...");
    }

    @Override
    public UserInstanceType describeService() throws ServiceException {
        throw new ServiceException("Unimplemented...");
    }

    @Override
    public String pwd() {
        if (!this.pwd.endsWith(File.separator)) {
            return this.pwd + File.separator;
        }
        return this.pwd;
    }

    private boolean exists(String path) {
        return new File(path).exists();
    }

    private boolean isDir(String path) {
        return new File(path).isDirectory();
    }

    @Override
    public void cd(String newDir) throws ServiceException {
        try {
            String path = this.toAbsPath(newDir);
            if (!this.isDir(path)) {
                throw new ResourcePermissionException(newDir, "path", "Path " + path + " is not a directory");
            }
            this.lastPath = this.pwd;
            this.pwd = path;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    @Override
    public void cd() throws ServiceException {
        this.cd(this.lastPath);
    }

    @Override
    public List<? extends PathType> list() throws ServiceException {
        return this.list(this.pwd);
    }

    @Override
    public List<? extends PathType> list(String dir) throws ServiceException {
        try {
            File[] listlocals;
            String path = this.toAbsPath(dir);
            ArrayList<PathType> list = new ArrayList<PathType>();
            if (!this.isDir(path)) {
                File local = new File(path);
                FilePathType filetype = new FilePathType();
                filetype.setPath(path);
                filetype.setMimeType(this.toMimeType(local.getName()));
                filetype.setInteger(String.valueOf(local.length()));
                filetype.setModifiedOn(new Date(local.lastModified()));
                list.add(filetype);
                return list;
            }
            for (File f : listlocals = new File(path).listFiles()) {
                if (f.isDirectory()) {
                    FolderPathType dirtype = new FolderPathType();
                    dirtype.setPath(f.getName());
                    list.add(dirtype);
                    continue;
                }
                FilePathType filetype = new FilePathType();
                filetype.setPath(f.getName());
                filetype.setMimeType(this.toMimeType(f.getName()));
                filetype.setInteger(String.valueOf(f.length()));
                filetype.setModifiedOn(new Date(f.lastModified()));
                list.add(filetype);
            }
            return list;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    private String toAbsPath(String path) throws Exception {
        if (path == null) {
            path = this.pwd();
        }
        File file = null;
        file = path.startsWith(File.separator) || new File(path).isAbsolute() ? new File(path) : new File(this.pwd(), path);
        String ret = file.getAbsoluteFile().getCanonicalPath();
        while (ret.endsWith(".")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    @Override
    public PathType describe(String path) throws ServiceException {
        try {
            path = this.toAbsPath(path);
            if (this.isDir(path)) {
                FolderPathType folder = new FolderPathType();
                folder.setPath(path);
                return folder;
            }
            String name = new File(path).getName();
            List<? extends PathType> list = this.list(path + "/..");
            for (PathType pathType : list) {
                if (!new File(pathType.getPath()).getName().equals(name)) continue;
                return pathType;
            }
            throw new UnknownResourceException(path, "path");
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    @Override
    public void mkdir(String dir) throws ServiceException {
        try {
            dir = this.toAbsPath(dir);
            if (this.exists(dir)) {
                throw new DuplicateResourceException(dir, "path");
            }
            if (!new File(dir).mkdirs()) {
                throw new ServiceException("Unable to create path." + dir);
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception", null, e);
        }
    }

    @Override
    public void delete(String dir, boolean recursive) throws ServiceException {
        try {
            dir = this.toAbsPath(dir);
            if (!this.exists(dir)) {
                throw new UnknownResourceException(dir, "path");
            }
            if (!recursive ? !new File(dir).delete() : !CommonUtils.deleteFolder(new File(dir))) {
                throw new ServiceException("Unable to delete path.");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    @Override
    public InputStream read(String path) throws ServiceException {
        try {
            path = this.toAbsPath(path);
            if (this.isDir(path)) {
                throw new ResourcePermissionException(path, "path", "Not a file");
            }
            if (!this.exists(path)) {
                throw new UnknownResourceException(path, "path");
            }
            return new FileInputStream(path);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    @Override
    public void write(String path, InputStream in, boolean force) throws ServiceException {
        try {
            path = this.toAbsPath(path);
            if (this.isDir(path)) {
                throw new ResourcePermissionException(path, "path", "Not a file");
            }
            if (force && !new File(path).getParentFile().exists() && !new File(path).getParentFile().mkdirs()) {
                throw new ServiceException("Unable to create path." + path);
            }
            CommonUtils.writeToFile(new File(path), in);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    @Override
    public void rename(String sourcepath, String destination, boolean force) throws ServiceException {
        try {
            sourcepath = this.toAbsPath(sourcepath);
            destination = this.toAbsPath(destination);
            if (!new File(sourcepath).exists()) {
                throw new UnknownResourceException(sourcepath, "path");
            }
            if (new File(destination).exists()) {
                if (new File(destination).isDirectory()) {
                    destination = new File(destination, new File(sourcepath).getName()).getAbsolutePath();
                } else {
                    throw new DuplicateResourceException(destination, "path");
                }
            }
            if (!new File(sourcepath).renameTo(new File(destination))) {
                throw new ServiceException("Unable to delete path.");
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    @Override
    public InputStream readAsZip(String path) throws ServiceException {
        throw new ServiceException("Unimplemented...");
    }

    @Override
    public void copy(String sourcepath, String destination, boolean force) throws ServiceException {
        try {
            sourcepath = this.toAbsPath(sourcepath);
            destination = this.toAbsPath(destination);
            if (!new File(sourcepath).exists()) {
                throw new UnknownResourceException(sourcepath, "path");
            }
            if (new File(destination).isDirectory()) {
                if (new File(sourcepath).isFile()) {
                    destination = new File(destination, new File(sourcepath).getName()).getAbsolutePath();
                } else {
                    throw new UnknownResourceException(sourcepath, "path");
                }
            }
            if (!force && new File(destination).exists()) {
                throw new DuplicateResourceException(destination, "path");
            }
            CommonUtils.writeToFile(new File(destination), new File(sourcepath));
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Unexpected exception:" + e.getMessage(), null, e);
        }
    }

    static {
        mimetuype.put("*", "application/octet-stream");
        mimetuype.put("asf", "video/x-ms-asf");
        mimetuype.put("txt", "text/plain");
        mimetuype.put("xml", "text/xml");
        mimetuype.put("asr", "video/x-ms-asf");
        mimetuype.put("asx", "video/x-ms-asf");
        mimetuype.put("au", "audio/basic");
        mimetuype.put("avi", "video/x-msvideo");
        mimetuype.put("c", "text/plain");
        mimetuype.put("cer", "application/x-x509-ca-cert");
        mimetuype.put("csh", "application/x-csh");
        mimetuype.put("css", "text/css");
        mimetuype.put("svg", "image/svg+xml");
        mimetuype.put("swf", "application/x-shockwave-flash");
        mimetuype.put("tgz", "application/x-compressed");
        mimetuype.put("xpm", "image/x-xpixmap");
        mimetuype.put("xwd", "image/x-xwindowdump");
        mimetuype.put("z", "application/x-compress");
        mimetuype.put("zip", "application/zip");
    }
}

