/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.api.exception;

import java.util.Arrays;
import java.util.List;
import oracle.cloudlogic.javaservice.types.FailedActionResponseType;
import oracle.cloudlogic.javaservice.utils.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceException
extends Exception {
    FailedActionResponseType response = new FailedActionResponseType();
    private Throwable cause = null;

    public ServiceException(String[] message, String stage, byte[] log) {
        super(message == null || message.length == 0 ? null : message[0]);
        this.response.setFailedStage(stage);
        this.response.setLog(CommonUtils.toEntitybody(log));
        if (message != null) {
            this.response.getMessage().addAll(Arrays.asList(message));
        }
    }

    public ServiceException(String message, String stage, byte[] log) {
        this(new String[]{message}, stage, log);
    }

    public ServiceException(List<String> message, String stage, byte[] log) {
        super(message == null || message.size() == 0 ? null : message.get(0));
        this.response.setFailedStage(stage);
        this.response.setLog(CommonUtils.toEntitybody(log));
        if (message != null) {
            this.response.getMessage().addAll(message);
        }
    }

    public ServiceException(FailedActionResponseType res) {
        this(res.getMessage(), res.getFailedStage(), (byte[])null);
        if (res.getLog() != null) {
            this.response.setLog(res.getLog());
        }
    }

    public ServiceException(String message, String stage, Throwable log) {
        this(CommonUtils.getAllInnerErrorMessages(message, log), stage, CommonUtils.fromThrowable(log));
    }

    public ServiceException(String message) {
        this(new String[]{message}, null, (byte[])null);
    }

    public ServiceException(String message, byte[] log) {
        this(new String[]{message}, null, log);
    }

    public FailedActionResponseType getResponse() {
        return this.response;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    private Exception create(String message, Exception cause) {
        if (message == null) {
            message = "";
        }
        if (cause != null) {
            return new Exception(message, cause);
        }
        return new Exception(message);
    }

    private Exception allMessagesAsException() {
        if (this.response == null || this.response.getMessage().isEmpty()) {
            return null;
        }
        Exception low = null;
        for (int i = this.response.getMessage().size() - 1; i >= 1; --i) {
            if (this.response.getMessage().get(i) == null || this.response.getMessage().get(i).equals("")) continue;
            low = this.create(this.response.getMessage().get(i), low);
        }
        return low;
    }

    public void translateMessagesIntoCause() {
        this.cause = this.allMessagesAsException();
    }
}

