/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriStateCheckBoxModelAdapter {
    protected final ModifiablePropertyValueModel<Boolean> booleanHolder;
    protected final PropertyChangeListener booleanChangeListener;
    protected final TriStateCheckBox button;
    protected final SelectionListener buttonSelectionListener;
    protected final DisposeListener buttonDisposeListener;

    public static TriStateCheckBoxModelAdapter adapt(ModifiablePropertyValueModel<Boolean> booleanHolder, TriStateCheckBox button) {
        return new TriStateCheckBoxModelAdapter(booleanHolder, button);
    }

    protected TriStateCheckBoxModelAdapter(ModifiablePropertyValueModel<Boolean> booleanHolder, TriStateCheckBox button) {
        Assert.isNotNull(booleanHolder, (String)"The boolean holder cannot be null");
        Assert.isNotNull((Object)button, (String)"The check box cannot be null");
        this.booleanHolder = booleanHolder;
        this.button = button;
        this.booleanChangeListener = this.buildBooleanChangeListener();
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.buttonDisposeListener = this.buildButtonDisposeListener();
        this.button.addDisposeListener(this.buttonDisposeListener);
        this.buttonSelectionListener = this.buildButtonSelectionListener();
        this.button.addSelectionListener(this.buttonSelectionListener);
        this.setButtonSelection((Boolean)this.booleanHolder.getValue());
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return SWTListenerTools.wrap(this.buildBooleanChangeListener_(), (Widget)this.button.getCheckBox());
    }

    protected PropertyChangeListener buildBooleanChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                TriStateCheckBoxModelAdapter.this.booleanChanged(event);
            }

            public String toString() {
                return "tri-state boolean listener";
            }
        };
    }

    protected SelectionListener buildButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TriStateCheckBoxModelAdapter.this.buttonSelected(event);
            }

            public String toString() {
                return "tri-state button selection listener";
            }
        };
    }

    protected DisposeListener buildButtonDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TriStateCheckBoxModelAdapter.this.buttonDisposed(event);
            }

            public String toString() {
                return "tri-state button dispose listener";
            }
        };
    }

    protected void booleanChanged(PropertyChangeEvent event) {
        this.setButtonSelection((Boolean)event.getNewValue());
    }

    protected void setButtonSelection(Boolean selection) {
        if (this.button.isDisposed()) {
            return;
        }
        this.button.setSelection(selection);
    }

    protected void buttonSelected(SelectionEvent event) {
        if (this.button.isDisposed()) {
            return;
        }
        this.booleanHolder.setValue((Object)this.button.getSelection());
    }

    protected void buttonDisposed(DisposeEvent event) {
        this.button.removeSelectionListener(this.buttonSelectionListener);
        this.button.removeDisposeListener(this.buttonDisposeListener);
        this.booleanHolder.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.booleanHolder);
    }
}

