/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.prefs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jpt.common.core.internal.utility.WorkspaceRunnableAdapter;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.JptUIPlugin;
import org.eclipse.jpt.common.ui.internal.jface.RunnableWithProgressAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public abstract class JptProblemSeveritiesPage
extends PropertyAndPreferencePage {
    private final HashMap<String, Integer> changedSeverities = new HashMap();
    private final ArrayList<Combo> combos = new ArrayList();
    private final ArrayList<ExpandableComposite> expandablePanes = new ArrayList();
    static final String VALIDATION_MESSAGE = ValidationMessage.class.getName();
    private ScrolledPageContent mainComposite;
    private final PreferenceSeverity[] preferenceSeverities = this.buildPreferenceSeverities();
    private final String[] severityDisplayStrings = this.buildSeverityDisplayStrings();
    private Boolean hasProjectSpecificPreferences = null;
    public static final String SETTINGS_EXPANDED = "expanded";
    public static final String SETTINGS_SECTION_NAME = "JpaProblemSeveritiesPage";
    protected static final PreferenceSeverity[] DEFAULT_PREFERENCE_SEVERITIES = JptProblemSeveritiesPage.buildDefaultPreferenceSeverities();

    protected IPreferenceStore doGetPreferenceStore() {
        return this.getUIPlugin().getPreferenceStore();
    }

    protected abstract JptUIPlugin getUIPlugin();

    protected PreferenceSeverity[] buildPreferenceSeverities() {
        return DEFAULT_PREFERENCE_SEVERITIES;
    }

    protected static PreferenceSeverity[] buildDefaultPreferenceSeverities() {
        ArrayList<PreferenceSeverity> severities = new ArrayList<PreferenceSeverity>();
        severities.add(new PreferenceSeverity(1, JptCommonUiMessages.PROBLEM_SEVERITIES_PAGE__ERROR));
        severities.add(new PreferenceSeverity(2, JptCommonUiMessages.PROBLEM_SEVERITIES_PAGE__WARNING));
        severities.add(new PreferenceSeverity(4, JptCommonUiMessages.PROBLEM_SEVERITIES_PAGE__INFO));
        severities.add(new PreferenceSeverity(8, JptCommonUiMessages.PROBLEM_SEVERITIES_PAGE__IGNORE));
        return severities.toArray(new PreferenceSeverity[severities.size()]);
    }

    protected String[] buildSeverityDisplayStrings() {
        int len = this.preferenceSeverities.length;
        String[] displayStrings = new String[len];
        int i = 0;
        while (i < len) {
            displayStrings[i] = this.preferenceSeverities[i].displayString;
            ++i;
        }
        return displayStrings;
    }

    protected Control createPreferenceContent(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.mainComposite = new ScrolledPageContent(container);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        this.mainComposite.setLayoutData((Object)gridData);
        parent = this.mainComposite.getBody();
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.addCombos(parent);
        this.restoreSectionExpansionStates();
        return container;
    }

    protected abstract void addCombos(Composite var1);

    protected void restoreSectionExpansionStates() {
        IDialogSettings settings = this.getDialogPreferences();
        int index = this.expandablePanes.size();
        while (index-- > 0) {
            ExpandableComposite expandablePane = this.expandablePanes.get(index);
            if (settings == null) {
                expandablePane.setExpanded(index == 0);
                continue;
            }
            expandablePane.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + index));
        }
    }

    public Point computeSize() {
        return this.doComputeSize();
    }

    protected Composite addExpandableSection(Composite parent, String text) {
        return this.addExpandableSection(parent, text, new GridData(4, 4, true, false));
    }

    protected Composite addSubExpandableSection(Composite parent, String text) {
        return this.addExpandableSection(parent, text, new GridData(4, 4, true, false, 2, 1));
    }

    private Composite addExpandableSection(Composite parent, String text, GridData gridData) {
        int expansionStype = 18;
        ExpandableComposite expandablePane = new ExpandableComposite(parent, 0, expansionStype);
        expandablePane.setText(text);
        expandablePane.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        expandablePane.setLayoutData((Object)gridData);
        expandablePane.addExpansionListener((IExpansionListener)this.buildExpansionListener());
        this.mainComposite.adaptChild((Control)expandablePane);
        this.expandablePanes.add(expandablePane);
        parent = new Composite((Composite)expandablePane, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        expandablePane.setClient((Control)parent);
        return parent;
    }

    private ExpansionAdapter buildExpansionListener() {
        return new ExpansionListener();
    }

    protected void expansionStateChanged() {
        this.mainComposite.reflow(true);
    }

    protected void addLabeledCombo(Composite parent, ValidationMessage validationMessage) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(String.valueOf(validationMessage.getDescription()) + ':');
        Combo combo = new Combo(parent, 8);
        combo.setItems(this.severityDisplayStrings);
        combo.setLayoutData((Object)new GridData(256));
        combo.setData(VALIDATION_MESSAGE, (Object)validationMessage);
        combo.select(this.getInitialComboIndex(validationMessage));
        combo.addSelectionListener(this.buildComboSelectionListener());
        this.mainComposite.adaptChild((Control)combo);
        this.combos.add(combo);
    }

    protected int getInitialComboIndex(ValidationMessage validationMessage) {
        return this.convertPreferenceValueToComboIndex(this.getPreferenceValue(validationMessage));
    }

    protected int getPreferenceValue(ValidationMessage validationMessage) {
        int prefValue = this.getPreferenceValue_(validationMessage);
        return prefValue != -1 ? prefValue : validationMessage.getDefaultSeverity();
    }

    protected int getPreferenceValue_(ValidationMessage validationMessage) {
        String prefKey = validationMessage.getID();
        return this.isProjectPreferencePage() && this.hasProjectSpecificOptions(this.getProject()) ? this.getValidationMessageSeverityPreference(this.getProject(), prefKey) : this.getValidationMessageSeverityPreference(prefKey);
    }

    protected int convertPreferenceValueToComboIndex(int prefValue) {
        int i = 0;
        while (i < this.preferenceSeverities.length) {
            if (prefValue == this.preferenceSeverities[i].preferenceValue) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("unknown preference value: " + prefValue);
    }

    private SelectionListener buildComboSelectionListener() {
        return new ComboSelectionListener();
    }

    protected void comboSelected(Combo combo) {
        ValidationMessage msg = (ValidationMessage)combo.getData(VALIDATION_MESSAGE);
        String prefKey = msg.getID();
        int prefValue = this.preferenceSeverities[combo.getSelectionIndex()].preferenceValue;
        this.changedSeverities.put(prefKey, prefValue);
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.getWorkspaceValidationPreferencesOverridden(project);
    }

    protected void performDefaults() {
        if (!this.isProjectPreferencePage()) {
            this.revertWorkspaceToDefaultPreferences();
        }
        super.performDefaults();
    }

    protected void revertWorkspaceToDefaultPreferences() {
        for (Combo combo : this.combos) {
            this.revertWorkspaceToDefaultPreference(combo);
        }
    }

    protected void revertWorkspaceToDefaultPreference(Combo combo) {
        ValidationMessage validationMessage = (ValidationMessage)combo.getData(VALIDATION_MESSAGE);
        String prefKey = validationMessage.getID();
        int prefValue = validationMessage.getDefaultSeverity();
        combo.select(this.convertPreferenceValueToComboIndex(prefValue));
        this.changedSeverities.put(prefKey, -1);
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.getDefaultsButton() == null) {
            return;
        }
        this.hasProjectSpecificPreferences = useProjectSpecificSettings;
        if (useProjectSpecificSettings) {
            this.copyCurrentPreferencesToProject();
        } else {
            this.revertProjectPreferences();
        }
    }

    protected void copyCurrentPreferencesToProject() {
        for (Combo combo : this.combos) {
            this.copyCurrentPreferenceToProject(combo);
        }
    }

    protected void copyCurrentPreferenceToProject(Combo combo) {
        ValidationMessage validationMessage = (ValidationMessage)combo.getData(VALIDATION_MESSAGE);
        String prefKey = validationMessage.getID();
        int prefValue = this.getValidationMessageSeverityPreference(prefKey);
        if (prefValue == -1) {
            prefValue = validationMessage.getDefaultSeverity();
        }
        combo.select(this.convertPreferenceValueToComboIndex(prefValue));
        this.changedSeverities.put(prefKey, prefValue);
    }

    protected void revertProjectPreferences() {
        for (Combo combo : this.combos) {
            this.revertProjectPreference(combo);
        }
    }

    protected void revertProjectPreference(Combo combo) {
        ValidationMessage validationMessage = (ValidationMessage)combo.getData(VALIDATION_MESSAGE);
        String prefKey = validationMessage.getID();
        int prefValue = this.getValidationMessageSeverityPreference(prefKey);
        if (prefValue == -1) {
            prefValue = validationMessage.getDefaultSeverity();
        }
        combo.select(this.convertPreferenceValueToComboIndex(prefValue));
        this.changedSeverities.put(prefKey, -1);
    }

    protected void noDefaultAndApplyButton() {
        throw new IllegalStateException("Don't call this, see enableProjectSpecificSettings for the hack that looks for the defaultsButton being null");
    }

    protected abstract int getValidationMessageSeverityPreference(IProject var1, String var2);

    protected abstract int getValidationMessageSeverityPreference(String var1);

    protected abstract boolean getWorkspaceValidationPreferencesOverridden(IProject var1);

    protected abstract void setWorkspaceValidationPreferencesOverridden(IProject var1, boolean var2);

    protected abstract void setValidationMessageSeverityPreference(String var1, int var2);

    protected abstract void setValidationMessageSeverityPreference(IProject var1, String var2, int var3);

    public boolean performOk() {
        super.performOk();
        if (this.hasProjectSpecificPreferences != null) {
            this.setWorkspaceValidationPreferencesOverridden(this.getProject(), this.hasProjectSpecificPreferences);
        }
        for (Map.Entry<String, Integer> entry : this.changedSeverities.entrySet()) {
            this.setProblemSeverityPreference(entry.getKey(), entry.getValue());
        }
        try {
            this.buildOKDialog().run(true, false, this.buildOKRunnable());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getTargetException());
        }
        return true;
    }

    protected void setProblemSeverityPreference(String prefKey, int value) {
        if (this.isProjectPreferencePage()) {
            this.setValidationMessageSeverityPreference(this.getProject(), prefKey, value);
        } else {
            this.setValidationMessageSeverityPreference(prefKey, value);
        }
    }

    private IRunnableContext buildOKDialog() {
        return new ProgressMonitorDialog(this.getShell());
    }

    private IRunnableWithProgress buildOKRunnable() {
        return new OKRunnable();
    }

    IWorkspaceRunnable buildOkWorkspaceRunnable() {
        return new OKWorkspaceRunnable();
    }

    void performOk_(IProgressMonitor monitor) throws CoreException {
        int buildKind = 6;
        IProject project = this.getProject();
        if (project != null) {
            project.build(buildKind, monitor);
        } else {
            ResourcesPlugin.getWorkspace().build(buildKind, monitor);
        }
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogPreferences());
        super.dispose();
    }

    protected IDialogSettings getDialogPreferences() {
        return this.getUIPlugin().getDialogSettings(SETTINGS_SECTION_NAME);
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int index = this.expandablePanes.size();
        while (index-- > 0) {
            ExpandableComposite expandablePane = this.expandablePanes.get(index);
            settings.put(SETTINGS_EXPANDED + index, expandablePane.isExpanded());
        }
    }

    class ComboSelectionListener
    extends SelectionAdapter {
        ComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            JptProblemSeveritiesPage.this.comboSelected((Combo)e.widget);
        }
    }

    class ExpansionListener
    extends ExpansionAdapter {
        ExpansionListener() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            JptProblemSeveritiesPage.this.expansionStateChanged();
        }
    }

    class OKRunnable
    extends RunnableWithProgressAdapter {
        OKRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                this.run_(monitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private void run_(IProgressMonitor monitor) throws CoreException {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.run(JptProblemSeveritiesPage.this.buildOkWorkspaceRunnable(), (ISchedulingRule)ws.getRoot(), 1, monitor);
        }
    }

    class OKWorkspaceRunnable
    extends WorkspaceRunnableAdapter {
        OKWorkspaceRunnable() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            JptProblemSeveritiesPage.this.performOk_(monitor);
        }
    }

    public static class PreferenceSeverity {
        public final int preferenceValue;
        public final String displayString;

        public PreferenceSeverity(int preferenceValue, String displayString) {
            this.preferenceValue = preferenceValue;
            this.displayString = displayString;
        }
    }
}

