/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.views;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WLSTRunnerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.scripting.ui.views.AbstractInfoView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.Bundle;
import org.python.pydev.editor.PyEdit;

public class WLSTHelpView
extends AbstractInfoView {
    private static final String WLST_OFFLINE_PROMPT = "wls:/offline>";
    public static final String ID = "oracle.eclipse.tools.weblogic.scripting.ui.views.WLSTHelpView";
    private HashMap<org.eclipse.wst.common.project.facet.core.runtime.IRuntime, StreamsProxy> wlstProcessMap = new HashMap();
    private HashMap<IRuntime, Process> wlstRtProcMap = new HashMap();
    private IProgressMonitor fComputeProgressMonitor;
    private Browser fBrowser;
    private StyledText fText;
    private BackAction fBackAction;
    private ForthAction fForthAction;
    private LinkAction fToggleLinkAction;
    private static String fgStyleSheet;
    private static boolean fgStyleSheetLoaded;
    private boolean fIsUsingBrowserWidget;
    private RGB fBackgroundColorRGB;
    private volatile int fComputeCount;
    private HTMLTextPresenter fPresenter;
    private final TextPresentation fPresentation = new TextPresentation();
    private String fOriginalInput;
    private BrowserInput fCurrent;

    static {
        fgStyleSheetLoaded = false;
    }

    public void setInput(BrowserInput input) {
        this.fCurrent = input;
        if (input.getInputElement() != null) {
            this.computeAndDoSetInput(null, input.getInputElement().toString());
        }
        this.fForthAction.update();
        this.fBackAction.update();
    }

    @Override
    protected void internalCreatePartControl(Composite parent) {
        try {
            this.fBrowser = new Browser(parent, 0);
            this.fBrowser.setJavascriptEnabled(true);
            this.fIsUsingBrowserWidget = true;
            this.fBrowser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    event.required = true;
                }
            });
        }
        catch (SWTError sWTError) {
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(parent, 768);
            this.fText.setEditable(false);
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    WLSTHelpView.this.doSetInput(WLSTHelpView.this.fOriginalInput);
                }
            });
        }
        WLSTHelpView.initStyleSheet();
        this.doSetInput(this.getDefaultHelpText());
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fBackAction = new BackAction();
        this.fBackAction.setActionDefinitionId("org.eclipse.ui.navigate.back");
        this.fForthAction = new ForthAction();
        this.fForthAction.setActionDefinitionId("org.eclipse.ui.navigate.forward");
        this.fToggleLinkAction = new LinkAction();
        this.fToggleLinkAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
    }

    @Override
    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.fBackAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.fForthAction);
    }

    @Override
    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fBackAction);
        tbm.add((IAction)this.fForthAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fToggleLinkAction);
        super.fillToolBar(tbm);
    }

    @Override
    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        menu.appendToGroup("group.goto", (IAction)this.fBackAction);
        menu.appendToGroup("group.goto", (IAction)this.fForthAction);
    }

    @Override
    protected void doSetInput(Object input) {
        String helpInHtml;
        this.fOriginalInput = helpInHtml = (String)input;
        if (this.fIsUsingBrowserWidget) {
            if (helpInHtml != null && helpInHtml.length() > 0) {
                boolean RTL;
                boolean bl = RTL = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
                if (RTL) {
                    StringBuffer buffer = new StringBuffer(helpInHtml);
                    HTMLPrinter.insertStyles((StringBuffer)buffer, (String[])new String[]{"direction:rtl"});
                    helpInHtml = buffer.toString();
                }
            }
            if (this.fBrowser != null) {
                this.fBrowser.setText(helpInHtml);
            }
        } else {
            this.fPresentation.clear();
            Rectangle size = this.fText.getClientArea();
            try {
                helpInHtml = this.fPresenter.updatePresentation((Drawable)this.fText, helpInHtml, this.fPresentation, size.width, size.height);
            }
            catch (Exception exception) {}
            this.fText.setText(helpInHtml);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    private String computeDescription(IWorkbenchPart part, ISelection selection, String inputElement, IProgressMonitor monitor) {
        return "";
    }

    @Override
    Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    @Override
    protected void setForeground(Color color) {
        this.getControl().setForeground(color);
    }

    @Override
    protected void setBackground(Color color) {
        this.getControl().setBackground(color);
        this.fBackgroundColorRGB = color.getRGB();
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
        if (!this.isLinkingEnabled()) {
            return;
        }
        this.computeAndSetInput(part);
    }

    @Override
    protected void computeAndSetInput(IWorkbenchPart part) {
        this.computeAndDoSetInput(part, null);
    }

    private void computeAndDoSetInput(final IWorkbenchPart part, final String element) {
        ISelection selection;
        Assert.isLegal((part != null || element != null ? 1 : 0) != 0);
        final int currentCount = ++this.fComputeCount;
        if (element != null) {
            selection = null;
        } else {
            ISelectionProvider provider = part.getSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            selection = provider.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
        }
        if (this.fComputeProgressMonitor != null) {
            this.fComputeProgressMonitor.setCanceled(true);
        }
        NullProgressMonitor computeProgressMonitor = new NullProgressMonitor();
        this.fComputeProgressMonitor = computeProgressMonitor;
        Thread thread = new Thread("Info view input computer", (IProgressMonitor)computeProgressMonitor){
            private final /* synthetic */ IProgressMonitor val$computeProgressMonitor;
            {
                this.val$computeProgressMonitor = iProgressMonitor;
                super($anonymous0);
            }

            @Override
            public void run() {
                String newElement;
                if (currentCount != WLSTHelpView.this.fComputeCount) {
                    return;
                }
                if (element != null) {
                    newElement = element;
                } else {
                    newElement = WLSTHelpView.this.findSelectedWLSTElement(part, selection);
                    if (newElement != null && newElement.trim().length() > 0) {
                        WLSTHelpView.this.fCurrent = new WLSTCommandBrowserInput(WLSTHelpView.this.fCurrent, newElement);
                        WLSTHelpView.this.fForthAction.update();
                        WLSTHelpView.this.fBackAction.update();
                    }
                }
                final Object input = WLSTHelpView.this.computeInput(part, selection, newElement, this.val$computeProgressMonitor);
                if (input == null) {
                    return;
                }
                final String description = WLSTHelpView.this.computeDescription(part, selection, newElement, this.val$computeProgressMonitor);
                Shell shell = WLSTHelpView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (WLSTHelpView.this.fComputeCount != currentCount || WLSTHelpView.this.getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        WLSTHelpView.this.doSetInput(input, description);
                        WLSTHelpView.this.fComputeProgressMonitor = null;
                    }
                });
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    protected Object computeInput(IWorkbenchPart part, ISelection selection, String input, IProgressMonitor monitor) {
        FileEditorInput fi;
        IProject project;
        IRuntimeComponent rtComp;
        if (this.getControl() == null || input == null) {
            return input;
        }
        IEditorPart editor = (IEditorPart)part;
        if (editor == null) {
            final IEditorPart[] result = new IEditorPart[]{null};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                }
            });
            editor = result[0];
        }
        if (editor != null && editor.getEditorInput() instanceof FileEditorInput && (rtComp = WlsRuntimeUtil.getWlsRuntimeComponent((IProject)(project = (fi = (FileEditorInput)editor.getEditorInput()).getFile().getProject()))) != null) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt = rtComp.getRuntime();
            if (rt == null) {
                return null;
            }
            if (input.trim().length() == 0) {
                return null;
            }
            if (input != null && input.trim().length() > 0) {
                return this.getHelpTextInHtml(rt, input, monitor);
            }
            return this.getDefaultHelpText();
        }
        return null;
    }

    private Object getDefaultHelpText() {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, null, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader("Select a command in WLST source editor to see help information."));
        HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)"Reference:");
        String helpIndex = "<br/><a href=http://download.oracle.com/docs/cd/E12840_01/wls/docs103/config_scripting/reference.html>WLST Command and Variable Reference</a>";
        HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader(helpIndex));
        return buffer.toString();
    }

    private String getHelpTextInHtml(org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt, String input, IProgressMonitor monitor) {
        StringBuffer buffer = new StringBuffer();
        String script = "help('" + input + "')";
        try {
            String helpTextHtml = "";
            try {
                helpTextHtml = this.getWlstHelp(rt, script);
            }
            catch (Exception exception) {
                return this.getDefaultHelpText().toString();
            }
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)input);
            String[] sections = new String[]{"Description:", "Syntax:", "Example:"};
            int n1 = helpTextHtml.indexOf(sections[0]);
            int n2 = helpTextHtml.indexOf(sections[1]);
            int n3 = helpTextHtml.indexOf(sections[2]);
            if (n1 > 0 && n2 > 0 && n3 > 0) {
                String description = helpTextHtml.substring(n1 + sections[0].length(), n2);
                String[] links = description.split("http://");
                if (links.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < links.length) {
                        String s = links[i];
                        if (i == 0) {
                            sb.append(s);
                        } else {
                            int endOfLink = s.indexOf(" ");
                            if (endOfLink > 0) {
                                String link = s.substring(0, endOfLink);
                                if (link.endsWith(".")) {
                                    link = link.substring(0, link.length() - 1);
                                }
                                sb.append("<a href=http://" + link + ">" + link + "</a>");
                                String text = s.substring(endOfLink);
                                text = text.replaceAll("NOTE:", "<p/>NOTE:<br/>");
                                text = text.replaceAll("Note:", "<p/>Note:<br/>");
                                text = text.replaceAll("- ", "<li>");
                                text = text.replaceAll("\n\n", "<br/>");
                                sb.append(text);
                            } else {
                                sb.append(s);
                            }
                        }
                        ++i;
                    }
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader(sb.toString().trim()));
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (String)"<br/>");
                } else {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader(description + "".trim()));
                }
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)sections[1]);
                HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader("<pre>" + helpTextHtml.substring(n2 + sections[1].length(), n3).trim() + "</pre>"));
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)sections[2]);
                HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader("<pre>" + helpTextHtml.substring(n3 + sections[2].length()).trim() + "</pre>"));
            } else {
                HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader("<pre>" + helpTextHtml + "</pre>"));
            }
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, null, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)"Reference:");
            String helpIndex = "<br/><a href=http://download.oracle.com/docs/cd/E12840_01/wls/docs103/config_scripting/reference.html>WLST Command and Variable Reference</a>";
            HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new StringReader(helpIndex));
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return buffer.toString();
        }
        catch (Exception exception) {
            return this.getDefaultHelpText().toString();
        }
    }

    private String getWlstHelp(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime, String helpCmd) throws CoreException {
        try {
            StreamsProxy proxy = this.wlstProcessMap.get(runtime);
            if (proxy == null) {
                List cmdArgs = WLSTRunnerUtil.getWlstScriptCmd((IRuntime)RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime));
                String[] cmd = new String[cmdArgs.size()];
                cmdArgs.toArray(cmd);
                File workingDirectory = new File(cmd[0]).getParentFile();
                Process process = DebugPlugin.exec((String[])cmd, (File)workingDirectory);
                proxy = new StreamsProxy(process, "UTF-8");
                final boolean[] wlstStarted = new boolean[1];
                IStreamListener startUpListener = new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        if (text.contains(WLSTHelpView.WLST_OFFLINE_PROMPT)) {
                            wlstStarted[0] = true;
                            return;
                        }
                    }
                };
                proxy.getOutputStreamMonitor().addListener(startUpListener);
                this.wlstProcessMap.put(runtime, proxy);
                while (!wlstStarted[0]) {
                    Thread.sleep(500L);
                }
                proxy.getOutputStreamMonitor().removeListener(startUpListener);
                this.wlstRtProcMap.put(RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime), process);
                ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new IRuntimeLifecycleListener(){

                    public void runtimeAdded(IRuntime rt) {
                    }

                    public void runtimeChanged(IRuntime rt) {
                    }

                    public void runtimeRemoved(IRuntime rt) {
                        if (WLSTHelpView.this.wlstRtProcMap.keySet().contains(rt)) {
                            Process proc = (Process)WLSTHelpView.this.wlstRtProcMap.get(rt);
                            proc.destroy();
                            WLSTHelpView.this.wlstRtProcMap.remove(rt);
                        }
                    }
                });
            }
            final StringBuffer ret = new StringBuffer();
            final boolean[] helpTextEnded = new boolean[1];
            IStreamListener listener = new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    if (text.contains(WLSTHelpView.WLST_OFFLINE_PROMPT)) {
                        helpTextEnded[0] = true;
                    }
                    ret.append(text);
                }
            };
            proxy.getOutputStreamMonitor().addListener(listener);
            proxy.write(String.valueOf(helpCmd) + "\n");
            while (!helpTextEnded[0]) {
                Thread.sleep(50L);
            }
            proxy.getOutputStreamMonitor().removeListener(listener);
            String helpText = ret.toString().replace(WLST_OFFLINE_PROMPT, "");
            return helpText;
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            return this.getDefaultHelpText().toString();
        }
    }

    private static void initStyleSheet() {
        if (fgStyleSheetLoaded) {
            return;
        }
        fgStyleSheetLoaded = true;
        fgStyleSheet = WLSTHelpView.loadStyleSheet();
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream(), StandardCharsets.UTF_8));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                JavaPlugin.log((Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private void doSetInput(Object input, String description) {
        this.doSetInput(input);
    }

    protected String findSelectedWLSTElement(IWorkbenchPart part, ISelection selection) {
        try {
            if (part instanceof PyEdit && selection instanceof ITextSelection) {
                String text = ((ITextSelection)selection).getText();
                if (text != null && text.length() > 0) {
                    return text;
                }
                return this.selectWord(((PyEdit)part).getDocument(), ((ITextSelection)selection).getOffset());
            }
            if (selection instanceof IStructuredSelection) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    protected String selectWord(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++offset;
            }
            int end = offset;
            return document.get(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    @Override
    protected Object computeInput(Object input) {
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPage page;
        if (this.getControl() == null || !(input instanceof String)) {
            return null;
        }
        IWorkbenchPart part = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            part = page.getActivePart();
        }
        ISelection selection = null;
        if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null) {
            selection = provider.getSelection();
        }
        return this.computeInput(part, selection, (String)input, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected String getBackgroundColorKey() {
        return "org.eclipse.jdt.ui.JavadocView.backgroundColor";
    }

    @Override
    protected String getHelpContextId() {
        return null;
    }

    @Override
    protected void internalDispose() {
        this.fText = null;
        this.fBrowser = null;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    private final class BackAction
    extends Action {
        public BackAction() {
            this.setText("Back");
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        private void update() {
            if (WLSTHelpView.this.fCurrent != null && WLSTHelpView.this.fCurrent.getPrevious() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            WLSTHelpView.this.setInput(WLSTHelpView.this.fCurrent.getPrevious());
        }
    }

    private final class ForthAction
    extends Action {
        public ForthAction() {
            this.setText("Forward");
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void update() {
            if (WLSTHelpView.this.fCurrent != null && WLSTHelpView.this.fCurrent.getNext() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            WLSTHelpView.this.setInput(WLSTHelpView.this.fCurrent.getNext());
        }
    }

    private class LinkAction
    extends Action {
        public LinkAction() {
            super("Link with Selection", 2);
            WLSTHelpView.this.setTitleToolTip("Link with Selection");
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"synced.gif");
            this.setChecked(WLSTHelpView.this.isLinkingEnabled());
        }

        public void run() {
            WLSTHelpView.this.setLinkingEnabled(!WLSTHelpView.this.isLinkingEnabled());
        }
    }

    private static final class WLSTCommandBrowserInput
    extends BrowserInput {
        private final String fInput;

        public WLSTCommandBrowserInput(BrowserInput previous, String inputElement) {
            super(previous);
            Assert.isNotNull((Object)inputElement);
            this.fInput = inputElement;
        }

        public Object getInputElement() {
            return this.fInput;
        }

        public String getInputName() {
            return this.fInput;
        }
    }
}

