/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.internal.cnf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.MBeanUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.server.core.IServer;

public class MBeanNode
implements IPropertySource2 {
    private MBeanNode parent;
    private IServer server;
    private String name;
    private String path;
    private Map<String, String> attributes;

    public MBeanNode(IServer server, String name, MBeanNode parent) {
        this.server = server;
        this.name = name;
        this.parent = parent;
        this.path = parent == null ? null : (parent.path != null ? (parent.path.indexOf(47) < 0 ? String.valueOf(parent.path) + ":/" + name : String.valueOf(parent.path) + "/" + name) : name);
    }

    public MBeanNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public IServer getServer() {
        return this.server;
    }

    public String getPath() {
        return this.path;
    }

    public MBeanNode[] getChildren() {
        ArrayList<MBeanNode> ret = new ArrayList<MBeanNode>();
        WeblogicServer weblogic = (WeblogicServer)this.server.getAdapter(WeblogicServer.class);
        List children = MBeanUtil.getChildMBeanNames((WeblogicServer)weblogic, (String)this.path);
        for (String s : children) {
            ret.add(new MBeanNode(this.server, s, this));
        }
        return ret.toArray(new MBeanNode[ret.size()]);
    }

    public Map<String, String> getMBeanAttributes() {
        if (this.attributes == null) {
            WeblogicServer weblogic = (WeblogicServer)this.server.getAdapter(WeblogicServer.class);
            this.attributes = MBeanUtil.getMBeanAttributes((WeblogicServer)weblogic, (String)this.path);
        }
        return this.attributes;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        this.getMBeanAttributes();
        return this.attributes.get(id) != null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.getMBeanAttributes();
        IPropertyDescriptor[] ret = new IPropertyDescriptor[this.attributes.size()];
        int i = 0;
        for (String attrName : this.attributes.keySet()) {
            ret[i] = new TextPropertyDescriptor((Object)attrName, attrName);
            ++i;
        }
        return ret;
    }

    public Object getPropertyValue(Object id) {
        this.getMBeanAttributes();
        return this.attributes.get(id);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

