/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.weblogic.scripting.facets.internal.WlstFacetInstallConfig;
import oracle.eclipse.tools.weblogic.scripting.ui.internal.WlsScriptingUiPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public final class WlstFacetInstallPage
extends AbstractFacetWizardPage {
    private static final String WIZARD_PAGE_NAME = "wlst.facet.install.page";
    private static final String IMG_PATH_WLST_WIZBAN = "images/wlst-banner.png";
    private static final String IMG_KEY_SOURCE_FOLDER = "source.folder";
    public static final String IMG_PATH_SOURCE_FOLDER = "images/source-folder.png";
    private WlstFacetInstallConfig installConfig = null;
    private ImageRegistry imageRegistry = null;
    private TreeViewer sourceFoldersTreeViewer = null;
    private Tree sourceFoldersTree = null;
    private Button addButton = null;
    private Button editButton = null;
    private Button removeButton = null;

    public WlstFacetInstallPage() {
        super(WIZARD_PAGE_NAME);
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.setImageDescriptor(SwtUtil.createImageDescriptor(WlsScriptingUiPlugin.class, (String)IMG_PATH_WLST_WIZBAN));
        this.imageRegistry = new ImageRegistry();
        this.imageRegistry.put(IMG_KEY_SOURCE_FOLDER, SwtUtil.createImageDescriptor(WlsScriptingUiPlugin.class, (String)IMG_PATH_SOURCE_FOLDER));
    }

    public WlstFacetInstallConfig getConfig() {
        return this.installConfig;
    }

    public void setConfig(Object config) {
        this.installConfig = (WlstFacetInstallConfig)config;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdfill());
        composite.setLayout((Layout)GridLayoutUtil.gl((int)2));
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WlstFacetInstallPage.this.handleDisposeEvent();
            }
        });
        Label sourceFoldersLabel = new Label(composite, 0);
        sourceFoldersLabel.setLayoutData((Object)GridLayoutUtil.gdhspan((GridData)GridLayoutUtil.gd(), (int)2));
        sourceFoldersLabel.setText(Resources.sourceFoldersLabel);
        this.sourceFoldersTreeViewer = new TreeViewer(composite, 2048);
        this.sourceFoldersTree = this.sourceFoldersTreeViewer.getTree();
        this.sourceFoldersTree.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.sourceFoldersTreeViewer.setContentProvider((IContentProvider)new SourceFoldersContentProvider());
        this.sourceFoldersTreeViewer.setLabelProvider((IBaseLabelProvider)new SourceFoldersLabelProvider());
        this.sourceFoldersTreeViewer.setInput(new Object());
        this.sourceFoldersTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WlstFacetInstallPage.this.updateButtonEnablement();
            }
        });
        this.installConfig.addListener((IEventListener)new IEventListener<WlstFacetInstallConfig.ChangeEvent>(){

            public void handleEvent(WlstFacetInstallConfig.ChangeEvent event) {
                WlstFacetInstallPage.this.sourceFoldersTreeViewer.refresh();
            }
        }, WlstFacetInstallConfig.ChangeEvent.Type.SOURCE_FOLDERS_CHANGED);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)GridLayoutUtil.gdvalign((GridData)GridLayoutUtil.gd(), (int)128));
        buttons.setLayout((Layout)GridLayoutUtil.glmargins((GridLayout)GridLayoutUtil.gl((int)1), (int)0, (int)0));
        this.addButton = new Button(buttons, 8);
        this.addButton.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.addButton.setText(Resources.addFolderButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WlstFacetInstallPage.this.handleAddButtonPressed();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.editButton.setText(Resources.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WlstFacetInstallPage.this.handleEditButtonPressed();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.removeButton.setText(Resources.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WlstFacetInstallPage.this.handleRemoveButtonPressed();
            }
        });
        this.updateButtonEnablement();
        this.bindUiToModel();
        this.setControl((Control)composite);
        this.updatePageStatus();
    }

    protected void updatePageStatus() {
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.wst.server.ui.preferencePage";
        String id2 = "org.eclipse.wst.server.ui.runtime.preferencePage";
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id2, (String[])new String[]{id, id2}, null);
        return dialog.open() == 0;
    }

    private void bindUiToModel() {
    }

    private ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    private IPath getSelectedSourceFolder() {
        IStructuredSelection sel = (IStructuredSelection)this.sourceFoldersTreeViewer.getSelection();
        return (IPath)sel.getFirstElement();
    }

    private void updateButtonEnablement() {
        boolean haveSelection = !this.sourceFoldersTreeViewer.getSelection().isEmpty();
        this.editButton.setEnabled(haveSelection);
        this.removeButton.setEnabled(haveSelection);
    }

    private void handleAddButtonPressed() {
        InputDialog dialog = new InputDialog(this.addButton.getShell(), Resources.addSourceFolderDialogTitle, Resources.addSourceFolderDialogMessage, null, this.createSourceFolderInputValidator());
        if (dialog.open() == 0) {
            String path = dialog.getValue();
            this.installConfig.addSourceFolder((IPath)new Path(path));
        }
    }

    private void handleEditButtonPressed() {
        IPath selectedSourceFolder = this.getSelectedSourceFolder();
        InputDialog dialog = new InputDialog(this.addButton.getShell(), Resources.editSourceFolderDialogTitle, Resources.editSourceFolderDialogMessage, selectedSourceFolder.toOSString(), this.createSourceFolderInputValidator());
        if (dialog.open() == 0) {
            Path newSourceFolder = new Path(dialog.getValue());
            ArrayList<Path> sourceFolders = new ArrayList<Path>(this.installConfig.getSourceFolders());
            int position = sourceFolders.indexOf(selectedSourceFolder);
            sourceFolders.set(position, newSourceFolder);
            this.installConfig.setSourceFolders(sourceFolders);
        }
    }

    private void handleRemoveButtonPressed() {
        IPath selectedSourceFolder = this.getSelectedSourceFolder();
        this.installConfig.removeSourceFolder(selectedSourceFolder);
    }

    private void handleDisposeEvent() {
        this.imageRegistry.dispose();
    }

    private IInputValidator createSourceFolderInputValidator() {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        IFacetedProjectWorkingCopy fpjwc = this.installConfig.getFacetedProjectWorkingCopy();
        final String projectName = fpjwc.getProjectName();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                String fullPath = "/" + projectName + "/" + newText;
                IStatus result = ws.validatePath(fullPath, 2);
                if (result.getSeverity() == 4) {
                    return result.getMessage();
                }
                for (IPath p : WlstFacetInstallPage.this.installConfig.getSourceFolders()) {
                    String pathStr = p.toPortableString();
                    if (!pathStr.equals(newText)) continue;
                    return Resources.folderExisting;
                }
                return null;
            }
        };
        return validator;
    }

    public boolean isPageComplete() {
        WlstFacetInstallConfig cfg = this.getConfig();
        IStatus sts = cfg.validate();
        if (!sts.isOK()) {
            this.setErrorMessage(sts.getMessage());
        }
        return sts.isOK();
    }

    private static final class Resources
    extends NLS {
        public static String folderExisting;
        public static String pageTitle;
        public static String pageDescription;
        public static String sourceFoldersLabel;
        public static String addFolderButton;
        public static String editButton;
        public static String removeButton;
        public static String addSourceFolderDialogTitle;
        public static String addSourceFolderDialogMessage;
        public static String editSourceFolderDialogTitle;
        public static String editSourceFolderDialogMessage;

        static {
            Resources.initializeMessages((String)WlstFacetInstallPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class SourceFoldersContentProvider
    implements ITreeContentProvider {
        private SourceFoldersContentProvider() {
        }

        public Object[] getElements(Object element) {
            return WlstFacetInstallPage.this.getConfig().getSourceFolders().toArray();
        }

        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class SourceFoldersLabelProvider
    implements ILabelProvider {
        private SourceFoldersLabelProvider() {
        }

        public String getText(Object element) {
            return ((IPath)element).toOSString();
        }

        public Image getImage(Object element) {
            return WlstFacetInstallPage.this.getImageRegistry().get(WlstFacetInstallPage.IMG_KEY_SOURCE_FOLDER);
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

