/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.eclipse.ui.progress.UIJob;

public class WLSTConsoleViewer
extends IOConsoleViewer {
    private ArrayList<String> history = new ArrayList();
    private int index = -1;
    private String lastRecall = "";
    private static HashMap<String, String> autoCompletionMap = new HashMap();

    static {
        autoCompletionMap.put("cd", "('#')");
        autoCompletionMap.put("help", "()");
        autoCompletionMap.put("ls", "()");
        autoCompletionMap.put("exit(", ")");
        autoCompletionMap.put("connect(", "'weblogic', '#', 't3://localhost:7001')");
    }

    public WLSTConsoleViewer(Composite parent, TextConsole console) {
        super(parent, console);
    }

    void doAutoCompletion() {
        IDocument doc = this.getDocument();
        int n = doc.getLength() - 1;
        try {
            StringBuffer sb = new StringBuffer();
            char c = doc.getChar(n);
            while (c != '>') {
                sb.insert(0, doc.getChar(n));
                c = doc.getChar(--n);
            }
            String key = sb.toString().trim();
            String val = autoCompletionMap.get(key);
            if (val != null) {
                int totalLines;
                String textToAppend = autoCompletionMap.get(key);
                final int caretOffset = textToAppend.indexOf("#") > 0 ? textToAppend.indexOf("#") : textToAppend.length();
                final int offset = this.getTextWidget().getCaretOffset();
                int line = doc.getLineOfOffset(offset);
                if (line < (totalLines = doc.getNumberOfLines()) - 1) {
                    return;
                }
                doc.replace(offset, 0, textToAppend.replace("#", ""));
                UIJob job = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        WLSTConsoleViewer.this.getTextWidget().setFocus();
                        WLSTConsoleViewer.this.getTextWidget().setCaretOffset(offset + caretOffset);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule(100L);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        StyledText text = this.getTextWidget();
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                String text = null;
                if (e.keyCode == 0x1000001) {
                    if (WLSTConsoleViewer.this.index > 0) {
                        WLSTConsoleViewer wLSTConsoleViewer = WLSTConsoleViewer.this;
                        wLSTConsoleViewer.index = wLSTConsoleViewer.index - 1;
                        if (WLSTConsoleViewer.this.history.size() > 0) {
                            text = (String)WLSTConsoleViewer.this.history.get(WLSTConsoleViewer.this.index);
                            this.recall(text);
                        }
                    }
                    WLSTConsoleViewer.this.revealEndOfDocument();
                    e.doit = false;
                } else if (e.keyCode == 0x1000002) {
                    if (WLSTConsoleViewer.this.index < WLSTConsoleViewer.this.history.size()) {
                        WLSTConsoleViewer wLSTConsoleViewer = WLSTConsoleViewer.this;
                        wLSTConsoleViewer.index = wLSTConsoleViewer.index + 1;
                        if (WLSTConsoleViewer.this.index <= WLSTConsoleViewer.this.history.size() - 1) {
                            text = (String)WLSTConsoleViewer.this.history.get(WLSTConsoleViewer.this.index);
                            this.recall(text);
                        }
                    }
                    WLSTConsoleViewer.this.revealEndOfDocument();
                    e.doit = false;
                } else if (e.keyCode != 8) {
                    WLSTConsoleViewer.this.doAutoCompletion();
                }
            }

            private void recall(String text) {
                if (text != null) {
                    IDocument doc = WLSTConsoleViewer.this.getDocument();
                    int length = doc.getLength();
                    try {
                        WLSTConsoleViewer.this.getDocument().replace(length - WLSTConsoleViewer.this.lastRecall.length(), WLSTConsoleViewer.this.lastRecall.length(), text);
                        WLSTConsoleViewer.this.lastRecall = text;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        final TextTransfer textTransfer = TextTransfer.getInstance();
        int ops = 3;
        Transfer[] transfers = new Transfer[]{textTransfer};
        DropTarget target = new DropTarget((Control)this.getTextWidget(), ops);
        target.setTransfer(transfers);
        target.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent arg0) {
            }

            public void drop(DropTargetEvent event) {
                if (textTransfer.isSupportedType(event.currentDataType)) {
                    final String text = (String)event.data;
                    IDocument doc = WLSTConsoleViewer.this.getDocument();
                    try {
                        final int offset = WLSTConsoleViewer.this.getTextWidget().getCaretOffset();
                        int line = doc.getLineOfOffset(offset);
                        int totalLines = doc.getNumberOfLines();
                        if (line < totalLines - 1) {
                            return;
                        }
                        doc.replace(offset, 0, text);
                        UIJob job = new UIJob(""){

                            public IStatus runInUIThread(IProgressMonitor arg0) {
                                WLSTConsoleViewer.this.getTextWidget().setFocus();
                                WLSTConsoleViewer.this.getTextWidget().setCaretOffset(offset + text.length());
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule(100L);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }

            public void dragOver(DropTargetEvent arg0) {
            }

            public void dragOperationChanged(DropTargetEvent arg0) {
            }

            public void dragLeave(DropTargetEvent arg0) {
            }

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }
        });
    }

    protected void revealEndOfDocument() {
        super.revealEndOfDocument();
        StyledText text = this.getTextWidget();
        text.setCaretOffset(text.getCharCount());
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        this.lastRecall = "";
        IConsoleDocumentPartitioner partitioner = (IConsoleDocumentPartitioner)this.getDocument().getDocumentPartitioner();
        if (!partitioner.isReadOnly(e.start)) {
            int lineCnt;
            StyledText text;
            String lastLine;
            int n;
            String[] legalLineDelimiters = this.getDocument().getLegalLineDelimiters();
            boolean isCarriageReturn = false;
            int i = 0;
            while (i < legalLineDelimiters.length) {
                if (e.text.equals(legalLineDelimiters[i])) {
                    isCarriageReturn = true;
                    break;
                }
                ++i;
            }
            if (isCarriageReturn && (n = (lastLine = (text = this.getTextWidget()).getLine((lineCnt = text.getLineCount()) - 1)).indexOf(62)) > 0) {
                String line = lastLine.substring(n + 1).trim();
                this.history.add(line);
                this.index = this.history.size();
            }
        }
        super.handleVerifyEvent(e);
    }
}

