/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.ui.internal;

import java.util.TreeMap;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.scripting.ui.internal.OpenWlstConsoleAction;
import oracle.eclipse.tools.weblogic.scripting.ui.internal.WlsScriptingUiPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.ViewPluginAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Server;

public class WLSTConsoleViewActionDelegate
implements IViewActionDelegate,
IMenuCreator,
IActionDelegate2 {
    private Menu fMenu;

    public void init(IViewPart view) {
    }

    public void init(IAction action) {
    }

    public void run(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        } else if (event.widget instanceof MenuItem) {
            ViewPluginAction va = (ViewPluginAction)action;
            TreeSelection ts = (TreeSelection)va.getSelection();
            Server server = (Server)ts.getFirstElement();
            IRuntime rt = server.getRuntime();
            OpenWlstConsoleAction openAction = new OpenWlstConsoleAction("", null, rt);
            openAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int accel = 1;
        TreeMap<String, IRuntime> map = new TreeMap<String, IRuntime>();
        for (IRuntime rt : WebLogicServerUtil.getWebLogicRuntimes()) {
            String label = rt.getName();
            map.put(label, rt);
        }
        for (String label : map.keySet()) {
            IRuntime rt = (IRuntime)map.get(label);
            ImageDescriptor image = WlsScriptingUiPlugin.IMG_DESC_WLST;
            this.addActionToMenu(this.fMenu, new OpenWlstConsoleAction(label, image, rt), accel);
            ++accel;
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }
}

