/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.ResponseSource;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HeaderParser;
import com.squareup.okhttp.internal.http.HttpDate;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.Response;
import com.squareup.okhttp.internal.http.StatusLine;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class CacheStrategy {
    private static final Response.Body EMPTY_BODY = new Response.Body(){

        @Override
        public boolean ready() throws IOException {
            return true;
        }

        @Override
        public MediaType contentType() {
            return null;
        }

        @Override
        public long contentLength() {
            return 0L;
        }

        @Override
        public InputStream byteStream() {
            return Util.EMPTY_INPUT_STREAM;
        }
    };
    private static final StatusLine GATEWAY_TIMEOUT_STATUS_LINE;
    public final Request request;
    public final Response response;
    public final ResponseSource source;

    private CacheStrategy(Request request, Response response, ResponseSource source) {
        this.request = request;
        this.response = response;
        this.source = source;
    }

    public static boolean isCacheable(Response response, Request request) {
        int responseCode = response.code();
        if (responseCode != 200 && responseCode != 203 && responseCode != 300 && responseCode != 301 && responseCode != 410) {
            return false;
        }
        CacheControl responseCaching = response.cacheControl();
        if (request.header("Authorization") != null && !responseCaching.isPublic() && !responseCaching.mustRevalidate() && responseCaching.sMaxAgeSeconds() == -1) {
            return false;
        }
        return !responseCaching.noStore();
    }

    static {
        try {
            GATEWAY_TIMEOUT_STATUS_LINE = new StatusLine("HTTP/1.1 504 Gateway Timeout");
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static class Factory {
        final long nowMillis;
        final Request request;
        final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds = -1;

        public Factory(long nowMillis, Request request, Response cacheResponse) {
            this.nowMillis = nowMillis;
            this.request = request;
            this.cacheResponse = cacheResponse;
            if (cacheResponse != null) {
                for (int i = 0; i < cacheResponse.headers().size(); ++i) {
                    String fieldName = cacheResponse.headers().name(i);
                    String value = cacheResponse.headers().value(i);
                    if ("Date".equalsIgnoreCase(fieldName)) {
                        this.servedDate = HttpDate.parse(value);
                        this.servedDateString = value;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(fieldName)) {
                        this.expires = HttpDate.parse(value);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase(fieldName)) {
                        this.lastModified = HttpDate.parse(value);
                        this.lastModifiedString = value;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase(fieldName)) {
                        this.etag = value;
                        continue;
                    }
                    if ("Age".equalsIgnoreCase(fieldName)) {
                        this.ageSeconds = HeaderParser.parseSeconds(value);
                        continue;
                    }
                    if (OkHeaders.SENT_MILLIS.equalsIgnoreCase(fieldName)) {
                        this.sentRequestMillis = Long.parseLong(value);
                        continue;
                    }
                    if (!OkHeaders.RECEIVED_MILLIS.equalsIgnoreCase(fieldName)) continue;
                    this.receivedResponseMillis = Long.parseLong(value);
                }
            }
        }

        public CacheStrategy get() {
            CacheStrategy candidate = this.getCandidate();
            if (candidate.source != ResponseSource.CACHE && this.request.cacheControl().onlyIfCached()) {
                Response noneResponse = new Response.Builder().request(candidate.request).statusLine(GATEWAY_TIMEOUT_STATUS_LINE).setResponseSource(ResponseSource.NONE).body(EMPTY_BODY).build();
                return new CacheStrategy(candidate.request, noneResponse, ResponseSource.NONE);
            }
            return candidate;
        }

        private CacheStrategy getCandidate() {
            Request conditionalRequest;
            if (this.cacheResponse == null) {
                return new CacheStrategy(this.request, this.cacheResponse, ResponseSource.NETWORK);
            }
            if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                return new CacheStrategy(this.request, this.cacheResponse, ResponseSource.NETWORK);
            }
            if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                return new CacheStrategy(this.request, this.cacheResponse, ResponseSource.NETWORK);
            }
            CacheControl requestCaching = this.request.cacheControl();
            if (requestCaching.noCache() || Factory.hasConditions(this.request)) {
                return new CacheStrategy(this.request, this.cacheResponse, ResponseSource.NETWORK);
            }
            long ageMillis = this.cacheResponseAge();
            long freshMillis = this.computeFreshnessLifetime();
            if (requestCaching.maxAgeSeconds() != -1) {
                freshMillis = Math.min(freshMillis, TimeUnit.SECONDS.toMillis(requestCaching.maxAgeSeconds()));
            }
            long minFreshMillis = 0L;
            if (requestCaching.minFreshSeconds() != -1) {
                minFreshMillis = TimeUnit.SECONDS.toMillis(requestCaching.minFreshSeconds());
            }
            long maxStaleMillis = 0L;
            CacheControl responseCaching = this.cacheResponse.cacheControl();
            if (!responseCaching.mustRevalidate() && requestCaching.maxStaleSeconds() != -1) {
                maxStaleMillis = TimeUnit.SECONDS.toMillis(requestCaching.maxStaleSeconds());
            }
            if (!responseCaching.noCache() && ageMillis + minFreshMillis < freshMillis + maxStaleMillis) {
                long oneDayMillis;
                Response.Builder builder = this.cacheResponse.newBuilder().setResponseSource(ResponseSource.CACHE);
                if (ageMillis + minFreshMillis >= freshMillis) {
                    builder.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                }
                if (ageMillis > (oneDayMillis = 86400000L) && this.isFreshnessLifetimeHeuristic()) {
                    builder.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                }
                return new CacheStrategy(this.request, builder.build(), ResponseSource.CACHE);
            }
            Request.Builder conditionalRequestBuilder = this.request.newBuilder();
            if (this.lastModified != null) {
                conditionalRequestBuilder.header("If-Modified-Since", this.lastModifiedString);
            } else if (this.servedDate != null) {
                conditionalRequestBuilder.header("If-Modified-Since", this.servedDateString);
            }
            if (this.etag != null) {
                conditionalRequestBuilder.header("If-None-Match", this.etag);
            }
            ResponseSource responseSource = Factory.hasConditions(conditionalRequest = conditionalRequestBuilder.build()) ? ResponseSource.CONDITIONAL_CACHE : ResponseSource.NETWORK;
            return new CacheStrategy(conditionalRequest, this.cacheResponse, responseSource);
        }

        private long computeFreshnessLifetime() {
            CacheControl responseCaching = this.cacheResponse.cacheControl();
            if (responseCaching.maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(responseCaching.maxAgeSeconds());
            }
            if (this.expires != null) {
                long servedMillis = this.servedDate != null ? this.servedDate.getTime() : this.receivedResponseMillis;
                long delta = this.expires.getTime() - servedMillis;
                return delta > 0L ? delta : 0L;
            }
            if (this.lastModified != null && this.cacheResponse.request().url().getQuery() == null) {
                long servedMillis = this.servedDate != null ? this.servedDate.getTime() : this.sentRequestMillis;
                long delta = servedMillis - this.lastModified.getTime();
                return delta > 0L ? delta / 10L : 0L;
            }
            return 0L;
        }

        private long cacheResponseAge() {
            long apparentReceivedAge = this.servedDate != null ? Math.max(0L, this.receivedResponseMillis - this.servedDate.getTime()) : 0L;
            long receivedAge = this.ageSeconds != -1 ? Math.max(apparentReceivedAge, TimeUnit.SECONDS.toMillis(this.ageSeconds)) : apparentReceivedAge;
            long responseDuration = this.receivedResponseMillis - this.sentRequestMillis;
            long residentDuration = this.nowMillis - this.receivedResponseMillis;
            return receivedAge + responseDuration + residentDuration;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            return this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
        }

        private static boolean hasConditions(Request request) {
            return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
        }
    }
}

