/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.Request;
import java.io.IOException;
import java.net.URL;

public final class TunnelRequest {
    final String host;
    final int port;
    final String userAgent;
    final String proxyAuthorization;

    public TunnelRequest(String host, int port, String userAgent, String proxyAuthorization) {
        if (host == null) {
            throw new NullPointerException("host == null");
        }
        if (userAgent == null) {
            throw new NullPointerException("userAgent == null");
        }
        this.host = host;
        this.port = port;
        this.userAgent = userAgent;
        this.proxyAuthorization = proxyAuthorization;
    }

    String requestLine() {
        return "CONNECT " + this.host + ":" + this.port + " HTTP/1.1";
    }

    Request getRequest() throws IOException {
        Request.Builder result = new Request.Builder().url(new URL("https", this.host, this.port, "/"));
        result.header("Host", this.port == Util.getDefaultPort("https") ? this.host : this.host + ":" + this.port);
        result.header("User-Agent", this.userAgent);
        if (this.proxyAuthorization != null) {
            result.header("Proxy-Authorization", this.proxyAuthorization);
        }
        result.header("Proxy-Connection", "Keep-Alive");
        return result.build();
    }
}

