/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks;

import com.tasktop.c2c.server.common.service.domain.QueryResult;
import com.tasktop.c2c.server.tasks.domain.RepositoryConfiguration;
import com.tasktop.c2c.server.tasks.domain.Task;
import java.util.Collection;
import java.util.Date;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevClient;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevClientManager;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevTaskAttachmentHandler;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevTaskDataHandler;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevTaskMapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.osgi.util.NLS;

public class CloudDevRepositoryConnector
extends AbstractRepositoryConnector {
    private CloudDevClientManager clientManager;
    private CloudDevTaskDataHandler taskDataHandler = new CloudDevTaskDataHandler(this);
    private AbstractTaskAttachmentHandler attachmentHandler = new CloudDevTaskAttachmentHandler(this);

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public String getConnectorKind() {
        return "CloudDev";
    }

    public String getLabel() {
        return Resources.label;
    }

    public String getRepositoryUrlFromTaskUrl(String taskFullUrl) {
        if (taskFullUrl == null) {
            return null;
        }
        int index = taskFullUrl.indexOf("task/");
        return index == -1 ? null : taskFullUrl.substring(0, index);
    }

    public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(taskRepository, taskId, monitor);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public String getTaskIdFromTaskUrl(String taskFullUrl) {
        if (taskFullUrl == null) {
            return null;
        }
        int index = taskFullUrl.indexOf("task/");
        return index == -1 ? null : taskFullUrl.substring(index + "task/".length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        StringBuilder builder = new StringBuilder();
        builder.append(repositoryUrl);
        builder.append("/");
        builder.append("task");
        builder.append("/");
        builder.append(taskId);
        builder.append("/");
        return builder.toString();
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        Date newModifiedDate = null;
        TaskAttribute modifiedAttribute = taskData.getRoot().getAttribute("task.common.date.modified");
        if (modifiedAttribute != null) {
            newModifiedDate = taskData.getAttributeMapper().getDateValue(modifiedAttribute);
        }
        Date oldModifiedDate = task.getModificationDate();
        if (newModifiedDate != null && oldModifiedDate != null) {
            return newModifiedDate.compareTo(oldModifiedDate) != 0;
        }
        return true;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        try {
            CloudDevClient client = this.getCloudDevClientManager().getCloudDevClient(repository);
            QueryResult<Task> taskResult = client.query(query, monitor);
            RepositoryConfiguration configuration = this.getRepositoryConfiguration(repository, false, monitor);
            for (Task task : taskResult.getResultPage()) {
                TaskData taskData = this.taskDataHandler.createTaskDataFromTask(repository, configuration, task);
                taskData.setPartial(true);
                collector.accept(taskData);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public void updateRepositoryConfiguration(TaskRepository taskRepository, IProgressMonitor monitor) throws CoreException {
        if (taskRepository != null) {
            this.getRepositoryConfiguration(taskRepository, true, monitor);
        }
    }

    public RepositoryConfiguration getRepositoryConfiguration(TaskRepository taskRepository, boolean forceRefresh, IProgressMonitor monitor) throws CoreException {
        CloudDevClient client = this.getCloudDevClientManager().getCloudDevClient(taskRepository);
        return client.getRepositoryConfiguration(forceRefresh, monitor);
    }

    public CloudDevClientManager getCloudDevClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new CloudDevClientManager();
        }
        return this.clientManager;
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        Date originalModificationDate = task.getModificationDate();
        CloudDevTaskMapper mapper = new CloudDevTaskMapper(taskData);
        mapper.applyTo(task);
        CloudDevClient client = this.getCloudDevClientManager().getCloudDevClient(taskRepository);
        String url = client.getTaskUrl(taskRepository.getRepositoryUrl(), taskData.getTaskId());
        url = url.replaceAll("/s/", "/#projects/");
        url = url.replaceAll("/tasks/", "/");
        task.setUrl(url);
        TaskAttribute attributeStatus = taskData.getRoot().getMappedAttribute("task.common.status");
        if (attributeStatus != null) {
            boolean isComplete = client.isComplete(attributeStatus.getValue());
            if (isComplete) {
                Date modificationDate = mapper.getModificationDate();
                if (modificationDate == null) {
                    modificationDate = new Date(0L);
                }
                task.setCompletionDate(modificationDate);
            } else {
                task.setCompletionDate(null);
            }
        }
        if (taskData.isPartial()) {
            task.setModificationDate(originalModificationDate);
        }
    }

    public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
        return super.getTaskRelations(taskData);
    }

    public AbstractTaskAttachmentHandler getTaskAttachmentHandler() {
        return this.attachmentHandler;
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)CloudDevRepositoryConnector.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

