/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevClient;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class CloudDevClientManager
implements IRepositoryListener {
    private Map<String, CloudDevClient> clients = new HashMap<String, CloudDevClient>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudDevClient getCloudDevClient(TaskRepository repository) {
        CloudDevClient cloudDevClient;
        Map<String, CloudDevClient> map = this.clients;
        synchronized (map) {
            cloudDevClient = this.clients.get(repository.getRepositoryUrl());
            if (cloudDevClient == null) {
                cloudDevClient = new CloudDevClient(repository);
                this.clients.put(repository.getUrl(), cloudDevClient);
            }
        }
        return cloudDevClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(TaskRepository repository) {
        Map<String, CloudDevClient> map = this.clients;
        synchronized (map) {
            this.clients.remove(repository.getRepositoryUrl());
        }
    }

    public void repositoryAdded(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository);
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
        this.removeClient(repository);
    }
}

