/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.internal.operation;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.plugin.nature.PythonNature;

public class CreateWLSTOpFolderValidator
extends ValidationService {
    protected Status compute() {
        IResource resource;
        Value value = (Value)this.context(Value.class);
        Path path = (Path)value.content();
        if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toString())) != null) {
            IProject project = resource.getProject();
            PythonNature nature = PythonNature.getPythonNature((IProject)project);
            if (nature == null) {
                return Status.createErrorStatus((String)"Project is not configured for WLST development");
            }
            try {
                IPythonPathNature pathNature = PythonNature.getPythonPathNature((IProject)project);
                Set set = pathNature.getProjectSourcePathSet(true);
                String resPath = resource.getFullPath().toPortableString();
                if (!set.contains(resPath)) {
                    return Status.createErrorStatus((String)"Please select a WLST source folder");
                }
            }
            catch (CoreException e) {
                return Status.createErrorStatus((Throwable)e);
            }
        }
        return Status.createOkStatus();
    }
}

