/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WLSTRunnerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.scripting.internal.WlsScriptingPlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.StringSubstitution;
import org.python.pydev.debug.ui.launching.InvalidRunException;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class WLSTPythonRunnerConfig
extends PythonRunnerConfig {
    private static final String IMPORT_WLST_MODULE_STMT = "from wlstModule import *";
    private static boolean runOnce = false;
    private final ILaunchConfiguration configuration;
    private File wlsRtPath = null;

    public WLSTPythonRunnerConfig(ILaunchConfiguration conf, String mode, String run) throws CoreException, InvalidRunException, MisconfigurationException {
        super(conf, mode, run);
        this.configuration = conf;
        IPath file = this.resource[0];
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        IProject p = f.getProject();
        this.wlsRtPath = WlsRuntimeUtil.getWlsRuntimePath((IProject)p);
        String[] env = new String[this.envp.length + 2];
        System.arraycopy(this.envp, 0, env, 0, this.envp.length);
        if (this.wlsRtPath != null) {
            env[env.length - 2] = "BEA_HOME=" + this.wlsRtPath.getParentFile().getAbsolutePath();
            env[env.length - 1] = "WL_HOME=" + this.wlsRtPath.getAbsolutePath();
            this.envp = env;
        }
    }

    public static String[] getWLSTConsoleCommandLine(IRuntime runtime) throws CoreException, JDTNotAvailableException {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        File wlsRtPath = WlsRuntimeUtil.getWlsRuntimePath((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)RuntimeBridgeUtil.bridge((IRuntime)runtime));
        IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)runtime.getAdapter(IWeblogicServerRuntime.class);
        IPath javaVMLocation = wsr.getJavaVmLocation();
        String javaLoc = String.valueOf(javaVMLocation.toPortableString()) + "/bin/java";
        if (Platform.getOS().equals("win32")) {
            javaLoc = String.valueOf(javaLoc) + ".exe";
        }
        cmdArgs.add(javaLoc);
        cmdArgs.add("-classpath");
        String cpath = wlsRtPath + "/server/lib/weblogic.jar";
        String sep = System.getProperty("path.separator");
        File mwHome = WlsRuntimeUtil.getMwHome((File)runtime.getLocation().toFile());
        File oracleCommon = new File(mwHome, "oracle_common");
        if (oracleCommon.exists()) {
            String oracleCommonPath = oracleCommon.getAbsolutePath().replace('\\', '/');
            File libs = new File(String.valueOf(oracleCommonPath) + "/common/wlst/lib/");
            File[] fileArray = libs.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".jar")) {
                    cpath = String.valueOf(cpath) + sep + f.getAbsolutePath().replace('\\', '/');
                }
                ++n2;
            }
            File res = new File(String.valueOf(oracleCommonPath) + "/common/wlst/resources");
            File[] fileArray2 = res.listFiles();
            int n3 = fileArray2.length;
            n = 0;
            while (n < n3) {
                File f = fileArray2[n];
                if (f.getName().endsWith(".jar")) {
                    cpath = String.valueOf(cpath) + sep + f.getAbsolutePath().replace('\\', '/');
                }
                ++n;
            }
            File setWlstEnvCmd = new File(String.valueOf(oracleCommonPath) + "/common/bin/setWlstEnv.cmd");
            if (setWlstEnvCmd.exists()) {
                try {
                    String content = FileUtil.readTextFile((File)setWlstEnvCmd);
                    content = content.substring("SET CLASSPATH=%CLASSPATH%;".length());
                    cpath = String.valueOf(cpath) + content.replaceAll("%COMMON_COMPONENTS_HOME%", oracleCommonPath);
                }
                catch (IOException iOException) {}
            }
            cmdArgs.add(cpath);
            cmdArgs.add("-Dweblogic.wlstHome=" + oracleCommonPath + "/common/wlst");
            cmdArgs.add("-DORACLE_HOME=" + oracleCommonPath);
            cmdArgs.add("-DCOMMON_COMPONENTS_HOME=" + oracleCommonPath);
        } else {
            cmdArgs.add(cpath);
        }
        cmdArgs.add("-Dpython.cachedir.skip=true");
        cmdArgs.add("-Dprod.props.file=" + runtime.getLocation().toPortableString() + "/.product.properties");
        cmdArgs.add("-Xms32m");
        cmdArgs.add("-Xmx200m");
        cmdArgs.add("-XX:MaxPermSize=128m");
        cmdArgs.add("-XX:+UseSpinning");
        cmdArgs.add("weblogic.WLST");
        String[] retVal = new String[cmdArgs.size()];
        cmdArgs.toArray(retVal);
        return retVal;
    }

    public String[] getCommandLine(boolean makeVariableSubstitution) throws CoreException, JDTNotAvailableException {
        String[] argArray;
        if (this.isDebug) {
            return this.getJythonDebugCommandLine(makeVariableSubstitution);
        }
        IRuntime runtime = this.getRuntime();
        List cmdArgs = WLSTRunnerUtil.getWlstScriptCmd((IRuntime)runtime);
        cmdArgs.add(this.resource[0].toPortableString());
        String runArguments = PythonRunnerConfig.getArguments((ILaunchConfiguration)this.configuration, (boolean)false);
        String[] stringArray = argArray = PythonRunnerConfig.parseStringIntoList((String)runArguments);
        int n = argArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            cmdArgs.add(s);
            ++n2;
        }
        String[] retVal = new String[cmdArgs.size()];
        cmdArgs.toArray(retVal);
        return retVal;
    }

    public String[] getJythonDebugCommandLine(boolean makeVariableSubstitution) throws CoreException, JDTNotAvailableException {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        if (this.isJython()) {
            IRuntime runtime = this.getRuntime();
            IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)runtime.getAdapter(IWeblogicServerRuntime.class);
            IPath javaVMLocation = wsr.getJavaVmLocation();
            String javaLoc = String.valueOf(javaVMLocation.toPortableString()) + "/bin/java";
            if (Platform.getOS().equals("win32")) {
                javaLoc = String.valueOf(javaLoc) + ".exe";
            }
            if (!InterpreterInfo.isJythonExecutable((String)this.interpreter.toOSString())) {
                throw new RuntimeException("The jython jar must be specified as the interpreter to run. Found: " + this.interpreter);
            }
            cmdArgs.add(javaLoc);
            cmdArgs.add("-classpath");
            String cpath = this.interpreter + SimpleRunner.getPythonPathSeparator() + this.pythonpathUsed;
            cmdArgs.add(cpath);
            cmdArgs.add("-Dpython.cachedir.skip=true");
            cmdArgs.add("-Dpython.path=" + this.getWlstPythonPath(this.wlsRtPath));
            this.addVmArgs(cmdArgs);
            if (this.isDebug) {
                cmdArgs.add("org.python.util.jython");
                this.addDebugArgs(cmdArgs, "jython");
            } else {
                cmdArgs.add("weblogic.WLST");
            }
        }
        IPath[] iPathArray = this.resource;
        int javaVMLocation = this.resource.length;
        int wsr = 0;
        while (wsr < javaVMLocation) {
            IPath p = iPathArray[wsr];
            File f = this.processWlstFile(p);
            cmdArgs.add(f.getAbsolutePath());
            ++wsr;
        }
        String args = PythonRunnerConfig.getArguments((ILaunchConfiguration)this.configuration, (boolean)false);
        String[] runArguments = PythonRunnerConfig.parseStringIntoList((String)args);
        int i = 0;
        while (runArguments != null && i < runArguments.length) {
            cmdArgs.add(runArguments[i]);
            ++i;
        }
        String[] retVal = new String[cmdArgs.size()];
        cmdArgs.toArray(retVal);
        return retVal;
    }

    public IRuntime getRuntime() throws CoreException {
        IPath file = this.resource[0];
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        IProject p = f.getProject();
        IFacetedProject fp = ProjectFacetsManager.create((IProject)p);
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = fp.getPrimaryRuntime();
        if (runtime == null) {
            throw new CoreException(WlsScriptingPlugin.createErrorStatus("Project must be target to WebLogic runtime"));
        }
        IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
        return r;
    }

    private File processWlstFile(IPath p) throws CoreException {
        File wlstFile = new File(p.toPortableString());
        if (!wlstFile.exists()) {
            throw new CoreException(WlsScriptingPlugin.createErrorStatus("WLST file not existing: " + wlstFile.getAbsolutePath()));
        }
        try {
            String src = FileUtil.readTextFile((File)wlstFile);
            if (src.indexOf(IMPORT_WLST_MODULE_STMT) >= 0 && this.isDebug && !runOnce) {
                runOnce = true;
                String msg = "WLST script will be executed with jython interpreter in debug mode.\n";
                msg = String.valueOf(msg) + "If you import wlstModule into default name sapce with \"from wlstModule import *\",\n";
                msg = String.valueOf(msg) + "the global object 'cmo' will not be available in this mode.\n\n";
                msg = String.valueOf(msg) + "The workarounds are:\n";
                msg = String.valueOf(msg) + "import wlstModule with its own namesapce\n";
                msg = String.valueOf(msg) + "'import wlstModule as wl' \n";
                msg = String.valueOf(msg) + "or\n";
                msg = String.valueOf(msg) + "create a local cmo object from the return of cd() statement\n";
                msg = String.valueOf(msg) + "cmo=cd( MBEAN_PATH ) ";
                WlsScriptingPlugin.getDefault().getLog().log((IStatus)new Status(2, "oracle.eclipse.tools.weblogic.scripting", msg));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wlstFile;
    }

    private String getWlstPythonPath(File wlsRtPath) {
        String[] old;
        if (wlsRtPath == null) {
            return this.pythonpathUsed;
        }
        StringBuilder newPythonPath = new StringBuilder();
        String sep = System.getProperty("path.separator");
        String[] stringArray = old = this.pythonpathUsed.split(sep);
        int n = old.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.indexOf("jython-modules/Lib") > 0 && !this.isDebug) {
                newPythonPath.append(wlsRtPath + "/common/wlst/modules/");
            } else {
                newPythonPath.append(s);
            }
            newPythonPath.append(sep);
            ++n2;
        }
        return newPythonPath.toString();
    }

    private void addVmArgs(List<String> cmdArgs) throws CoreException {
        String[] vmArguments = this.getVMArguments(this.configuration);
        if (vmArguments != null) {
            int i = 0;
            while (i < vmArguments.length) {
                cmdArgs.add(vmArguments[i]);
                ++i;
            }
        }
    }

    private String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.python.pydev.debug.vm.arguments", null);
        if (args != null && args.trim().length() > 0) {
            String expanded = WLSTPythonRunnerConfig.getStringSubstitution((IPythonNature)PythonNature.getPythonNature((IProject)this.project)).performStringSubstitution(args);
            return WLSTPythonRunnerConfig.parseStringIntoList((String)expanded);
        }
        return null;
    }

    private static StringSubstitution getStringSubstitution(IPythonNature nature) {
        return new StringSubstitution(nature);
    }

    private void addDebugArgs(List<String> cmdArgs, String vmType) throws CoreException {
        if (this.isDebug) {
            cmdArgs.add(WLSTPythonRunnerConfig.getDebugScript());
            cmdArgs.add("--vm_type");
            cmdArgs.add(vmType);
            cmdArgs.add("--client");
            cmdArgs.add("localhost");
            cmdArgs.add("--port");
            int port = 8888;
            try {
                port = this.getDebuggerListenConnector().getLocalPort();
            }
            catch (IOException iOException) {}
            cmdArgs.add(Integer.toString(port));
            cmdArgs.add("--file");
        }
    }
}

