/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.scripting.internal.WLSTPythonRunnerConfig;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.AbstractLaunchConfigurationDelegate;
import org.python.pydev.debug.ui.launching.InvalidRunException;
import org.python.pydev.debug.ui.launching.PythonRunner;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;

public class WLSTLaunchConfigurationDelegate
extends AbstractLaunchConfigurationDelegate {
    protected String getRunnerConfigRun(ILaunchConfiguration arg0, String arg1, ILaunch arg2) {
        return "jython regular run";
    }

    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block13: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Preparing configuration", 3);
            try {
                WLSTPythonRunnerConfig runConfig = new WLSTPythonRunnerConfig(conf, mode, this.getRunnerConfigRun(conf, mode, launch));
                monitor.worked(1);
                try {
                    if (runConfig.isDebug) {
                        PythonRunner.run((PythonRunnerConfig)runConfig, (ILaunch)launch, (IProgressMonitor)monitor);
                        break block13;
                    }
                    Object[] cmdLine = runConfig.getCommandLine(false);
                    File workingDirectory = runConfig.workingDirectory;
                    String commandLineMsg = Arrays.toString(cmdLine);
                    LoggingService.logInfo((String)"oracle.eclipse.tools.weblogic.scripting", (String)("Launching WLST script: " + commandLineMsg));
                    IRuntime runtime = runConfig.getRuntime();
                    ProcessBuilder processBuilder = new ProcessBuilder((String[])cmdLine);
                    processBuilder.directory(workingDirectory);
                    Map<String, String> env = processBuilder.environment();
                    WeblogicServerRuntime rt = (WeblogicServerRuntime)runtime.loadAdapter(WeblogicServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                    if (rt.getDefaultJavaVmLocation() == null) {
                        try {
                            String mwHomePath = WlsRuntimeUtil.getMwHome((File)runtime.getLocation().toFile()).getCanonicalPath();
                            env.put("MW_HOME", new File(mwHomePath).getCanonicalPath().replace('\\', '/'));
                            env.put("JAVA_HOME", rt.getJavaVmLocation().toPortableString());
                        }
                        catch (IOException iOException) {}
                    }
                    Process process = processBuilder.start();
                    HashMap<String, String> processAttrs = new HashMap<String, String>();
                    processAttrs.put(IProcess.ATTR_PROCESS_TYPE, "java");
                    processAttrs.put(IProcess.ATTR_CMDLINE, commandLineMsg);
                    String path = String.valueOf(workingDirectory.getAbsolutePath().replace('\\', '/')) + "/wlst." + CorePlugin.getScriptExtension();
                    RuntimeProcess runtimeProcess = new RuntimeProcess(launch, process, path, processAttrs){

                        public boolean canTerminate() {
                            return false;
                        }
                    };
                    while (!runtimeProcess.isTerminated()) {
                        Thread.sleep(500L);
                    }
                    int exitCode = runtimeProcess.getExitValue();
                    if (exitCode != 0) {
                        String stdout = runtimeProcess.getStreamsProxy().getOutputStreamMonitor().getContents();
                        String errout = runtimeProcess.getStreamsProxy().getErrorStreamMonitor().getContents();
                        throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic.scripting", "Run failed: exitcode=" + exitCode + ", stdout=[" + stdout + "], stderr=[" + errout + "]"));
                    }
                }
                catch (IOException e) {
                    Log.log((Throwable)e);
                    this.finishLaunchWithError(launch);
                    throw new CoreException((IStatus)PydevDebugPlugin.makeStatus((int)4, (String)"Unexpected IO Exception in Pydev debugger", null));
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (InvalidRunException e) {
                this.handleError(launch, (Exception)((Object)e));
            }
            catch (MisconfigurationException e) {
                this.handleError(launch, (Exception)((Object)e));
            }
        }
    }

    private void handleError(ILaunch launch, final Exception e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid launch configuration", (String)"Unable to make launch because launch configuration is not valid", (IStatus)PydevPlugin.makeStatus((int)4, (String)e.getMessage(), (Throwable)e));
            }
        });
        this.finishLaunchWithError(launch);
    }

    private void finishLaunchWithError(ILaunch launch) {
        try {
            launch.terminate();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
        }
        catch (Throwable x) {
            Log.log((Throwable)x);
        }
    }
}

