/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import java.util.Collection;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.FormTextHTMLGenerator;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SaveSummaryViewer {
    private FormText formText;
    private IOEPEExecutableContext.ISaveSummary saveSummary;

    public void setInput(IOEPEExecutableContext.ISaveSummary saveSummary) {
        this.saveSummary = saveSummary;
        this.refresh();
    }

    public void dispose() {
        this.saveSummary = null;
        this.formText = null;
    }

    public IOEPEExecutableContext.ISaveSummary getInput() {
        return this.saveSummary;
    }

    public Control createControl(FormToolkit toolkit, Composite parent) {
        this.formText = DTRTUIUtil.createFormText(toolkit, parent, 2056);
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                HyperlinkEvent event = new HyperlinkEvent((Widget)SaveSummaryViewer.this.formText.getParent(), (Object)SaveSummaryViewer.this.getInput(), e.getLabel(), e.getStateMask());
                SaveSummaryViewer.this.handleHyperlinkActivated(event);
            }
        });
        this.refresh();
        return this.formText;
    }

    private void handleHyperlinkActivated(HyperlinkEvent event) {
    }

    public void refresh() {
        if (this.formText != null) {
            FormTextHTMLGenerator generator;
            if (this.getInput() == null || this.getInput().getFileCount() == 0) {
                FormTextHTMLGenerator.HTMLText text = new FormTextHTMLGenerator.HTMLText(this.formText);
                generator = text;
                text.addEncodedText(Messages.noFiles);
            } else {
                FormTextHTMLGenerator.HTMLUnorderedList unorderedList = new FormTextHTMLGenerator.HTMLUnorderedList(this.formText);
                generator = unorderedList;
                this.addList(unorderedList, Messages.created, this.saveSummary.getCreatedFiles());
                this.addList(unorderedList, Messages.deleted, this.saveSummary.getDeletedFiles());
                this.addList(unorderedList, Messages.changed, this.saveSummary.getChangedFiles());
            }
            generator.flush();
        }
    }

    private void addList(FormTextHTMLGenerator.HTMLUnorderedList unorderedList, String collectionMessage, Collection<? extends IFile> files) {
        if (!files.isEmpty()) {
            unorderedList.addEncodedText(NLS.bind((String)collectionMessage, (Object)files.size()));
            for (IFile iFile : files) {
                Image image = DTRTUIUtil.getImage(ImageManager.getInstance().getWorkbenchImageData((Object)iFile));
                unorderedList.addLI(image, null, iFile.getFullPath().toString());
            }
        }
    }

    static class Messages
    extends NLS {
        public static String noFiles;
        public static String created;
        public static String deleted;
        public static String changed;

        static {
            NLS.initializeMessages((String)SaveSummaryViewer.class.getName(), Messages.class);
        }

        Messages() {
        }
    }
}

