/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

class CustomSection
extends Section {
    private static Font sectionFont;

    public static CustomSection createSection(FormToolkit toolkit, Composite parent, boolean hyperlink, int sectionStyle) {
        if (sectionFont == null || sectionFont.isDisposed()) {
            Section dummy = toolkit.createSection(parent, 0);
            Font font = dummy.getFont();
            sectionFont = new Font(font.getDevice(), font.getFontData());
            dummy.dispose();
        }
        CustomSection section = new CustomSection(parent, hyperlink, toolkit.getOrientation() | sectionStyle);
        section.setMenu(parent.getMenu());
        toolkit.adapt((Control)section, true, true);
        if (section.toggle != null) {
            section.toggle.setHoverDecorationColor(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
            section.toggle.setDecorationColor(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        }
        section.setFont(sectionFont);
        if ((sectionStyle & 0x100) != 0 || (sectionStyle & 0x200) != 0) {
            toolkit.getColors().initializeSectionToolBarColors();
            section.setTitleBarBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
            section.setTitleBarBorderColor(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
        }
        section.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        return section;
    }

    public CustomSection(Composite parent, boolean hyperlink, int style) {
        super(parent, style);
        Hyperlink hyperlinkControl = new Hyperlink((Composite)this, 64);
        if (hyperlink) {
            hyperlinkControl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkEntered(HyperlinkEvent e) {
                    ((Hyperlink)e.widget).setUnderlined(true);
                }

                public void linkExited(HyperlinkEvent e) {
                    ((Hyperlink)e.widget).setUnderlined(false);
                }
            });
        } else {
            hyperlinkControl.setCursor(null);
        }
        this.textLabel = hyperlinkControl;
    }

    public Hyperlink getTextLabel() {
        return (Hyperlink)this.textLabel;
    }
}

