/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class UIDataControlProviderAdapter
implements IDataControlProvider.IDataControlProviderListener {
    private IDataControlProvider.IDataControlProviderListener listener;

    public UIDataControlProviderAdapter(IDataControlProvider.IDataControlProviderListener listener) {
        this.listener = listener;
    }

    public IDataControlProvider.IDataControlProviderListener getDataControlProviderListener() {
        return this.listener;
    }

    public void handleStructureChange(IDataControlProvider provider) {
        DataControlProviderListenerMethod.HANDLE_STRUCTURE_CHANGE.invoke(this.getDataControlProviderListener(), provider, new Object[0]);
    }

    public void handleStructureLoading(IDataControlProvider provider) {
        DataControlProviderListenerMethod.HANDLE_STRUCTURE_LOADING.invoke(this.getDataControlProviderListener(), provider, new Object[0]);
    }

    public void handleStructureReset(IDataControlProvider provider) {
        DataControlProviderListenerMethod.HANDLE_STRUCTURE_RESET.invoke(this.getDataControlProviderListener(), provider, new Object[0]);
    }

    private static enum DataControlProviderListenerMethod {
        HANDLE_STRUCTURE_LOADING,
        HANDLE_STRUCTURE_CHANGE,
        HANDLE_STRUCTURE_RESET;


        public Object invoke(final IDataControlProvider.IDataControlProviderListener listener, final IDataControlProvider dataControlProvider, final Object ... args) {
            Display display;
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (Throwable throwable) {
                display = null;
            }
            if (display != null) {
                if (Display.getCurrent() != null) {
                    return this.doInvoke(listener, dataControlProvider, args);
                }
                final Object[] ret = new Object[1];
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ret[0] = DataControlProviderListenerMethod.this.doInvoke(listener, dataControlProvider, args);
                    }
                });
                return ret[0];
            }
            return this.doInvoke(listener, dataControlProvider, args);
        }

        private Object doInvoke(IDataControlProvider.IDataControlProviderListener listener, IDataControlProvider dataControlProvider, Object ... args) {
            switch (this) {
                case HANDLE_STRUCTURE_CHANGE: {
                    listener.handleStructureChange(dataControlProvider);
                    return null;
                }
                case HANDLE_STRUCTURE_LOADING: {
                    listener.handleStructureLoading(dataControlProvider);
                    return null;
                }
                case HANDLE_STRUCTURE_RESET: {
                    listener.handleStructureReset(dataControlProvider);
                    return null;
                }
            }
            throw new IllegalStateException("Unhandled enumeration literal: " + (Object)((Object)this));
        }
    }
}

