/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DataControlObjectContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DataControlObjectTreeFilter;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SelectDataControlObjectDialog
extends TitleAreaDialog {
    private List<? extends IDataControlObject> input;
    private IDataControlObject dataControlObject;
    private ISelectionValidator selectionValidator;
    private Map<String, Object> data;

    public SelectDataControlObjectDialog(Shell parentShell, List<? extends IDataControlObject> input) {
        super(parentShell);
        this.input = input;
    }

    public void setSelectionValidator(ISelectionValidator selectionValidator) {
        this.selectionValidator = selectionValidator;
    }

    public ISelectionValidator getSelectionValidator() {
        return this.selectionValidator;
    }

    public void setSelection(IDataControlObject dataControlObject) {
        this.dataControlObject = dataControlObject;
    }

    public IDataControlObject getSelection() {
        return this.dataControlObject;
    }

    public Object setData(String key, Object value) {
        if (value != null) {
            if (this.data == null) {
                this.data = new HashMap<String, Object>(5);
            }
            return this.data.put(key, value);
        }
        if (this.data != null) {
            value = this.data.remove(key);
            if (this.data.isEmpty()) {
                this.data = null;
            }
        }
        return value;
    }

    public Object getData(String key) {
        return this.data != null ? this.data.get(key) : null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.topTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.topTitle);
        this.setMessage(Messages.topMessage);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        FilteredTree filteredTree = new FilteredTree(composite, 2052, (PatternFilter)new DataControlObjectTreeFilter(), true);
        TreeViewer treeViewer = filteredTree.getViewer();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        treeViewer.setContentProvider((IContentProvider)new DataControlObjectContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider().setFilteredTree(filteredTree));
        treeViewer.setComparator((ViewerComparator)new DescribableViewerComparator());
        treeViewer.setInput(this.input);
        if (this.dataControlObject != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.dataControlObject), true);
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectDataControlObjectDialog.this.handleSelectionChange(event);
            }
        });
        return composite;
    }

    private void handleSelectionChange(SelectionChangedEvent event) {
        IDataControlObject dataControlObject;
        Object selectectObject;
        this.dataControlObject = null;
        if (event != null && (selectectObject = DTRTUIUtil.getFirstElement(event.getSelection())) instanceof IDataControlObject && this.basicValidate(dataControlObject = (IDataControlObject)selectectObject) && (this.getSelectionValidator() == null || this.getSelectionValidator().isValidSelection(this, dataControlObject))) {
            this.dataControlObject = dataControlObject;
        }
        this.getButton(0).setEnabled(this.dataControlObject != null);
    }

    protected boolean basicValidate(IDataControlObject dataControlObject) {
        return !(dataControlObject instanceof IDataControlChild) || ((IDataControlChild)dataControlObject).getStructureObject() != null;
    }

    public static interface ISelectionValidator {
        public boolean isValidSelection(SelectDataControlObjectDialog var1, IDataControlObject var2);
    }

    private static class Messages
    extends NLS {
        public static String topTitle;
        public static String topMessage;

        static {
            NLS.initializeMessages((String)SelectDataControlObjectDialog.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

