/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.SaveSummaryViewer;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SaveSummaryDialog
extends TitleAreaDialog {
    private IOEPEExecutableContext.ISaveSummary saveSummary;
    private FormToolkit toolkit;
    private SaveSummaryViewer viewer;

    public SaveSummaryDialog(Shell parentShell, IOEPEExecutableContext.ISaveSummary saveSummary) {
        super(parentShell);
        this.saveSummary = saveSummary;
    }

    public boolean close() {
        this.saveSummary = null;
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }

    public IOEPEExecutableContext.ISaveSummary getSaveSummary() {
        return this.saveSummary;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.title);
        int fileCount = this.saveSummary.getFileCount();
        switch (fileCount) {
            case 0: {
                this.setMessage(Messages.noFilesMessage);
                break;
            }
            case 1: {
                this.setMessage(Messages.fileMessage);
                break;
            }
            default: {
                this.setMessage(NLS.bind((String)Messages.filesMessage, (Object)fileCount));
            }
        }
        Composite client = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(client);
        DTRTUIUtil.applyGrabAllGridData((Control)client);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.viewer = new SaveSummaryViewer();
        this.viewer.setInput(this.saveSummary);
        DTRTUIUtil.applyGrabAllGridData(this.viewer.createControl(this.toolkit, client));
        client.setFocus();
        return composite;
    }

    private static class Messages
    extends NLS {
        public static String title;
        public static String fileMessage;
        public static String filesMessage;
        public static String noFilesMessage;

        static {
            NLS.initializeMessages((String)SaveSummaryDialog.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

